<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create or update default admin user
        User::updateOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('password'),
                'role' => 'admin',
            ]
        );

        // Create or update Neil's admin user
        User::updateOrCreate(
            ['email' => 'neil@roberttodds.com'],
            [
                'name' => 'Neil Widdowson',
                'password' => Hash::make('password'),
                'role' => 'admin',
            ]
        );
    }
}
