<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Mail;

class ContactPage extends Component
{
    public $name = '';
    public $email = '';
    public $phone = '';
    public $subject = '';
    public $message = '';
    public $sent = false;

    public function submit()
    {
        $this->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'subject' => 'required|string|max:255',
            'message' => 'required|string|min:10',
        ]);

        // Here you would send the email
        // For now, we'll just flash a success message
        
        $this->sent = true;
        $this->reset(['name', 'email', 'phone', 'subject', 'message']);
        
        session()->flash('message', 'Thank you for contacting us! We\'ll get back to you soon.');
    }

    public function render()
    {
        return view('livewire.contact-page')->layout('layouts.shop');
    }
}




