<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\Contracts\LLMService;
use App\Services\Contracts\TTSService;
use App\Services\Contracts\SafetyService;
use App\Services\LLM\LLMManager;
use App\Services\TTS\TTSManager;
use App\Services\Safety\SimpleSafetyService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(LLMService::class, function () {
            return LLMManager::driver(config('providers.llm.driver'));
        });

        $this->app->bind(TTSService::class, function () {
            return TTSManager::driver(config('providers.tts.driver'));
        });

        $this->app->singleton(SafetyService::class, fn () => new SimpleSafetyService());
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
