<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(\App\Services\Contracts\LLMService::class, function () {
            return \App\Services\LLM\LLMManager::driver(config('providers.llm.driver'));
        });

        $this->app->bind(\App\Services\Contracts\TTSService::class, function () {
            return \App\Services\TTS\TTSManager::driver(config('providers.tts.driver'));
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
