<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">Items @isset($scopedSeason)<span class="text-muted">— {{ $scopedSeason->code }} ({{ $scopedSeason->label }})</span>@endisset</h1>
                <div class="d-flex gap-2">
                    @if(isset($scopedSeason))
                        <a href="{{ route('admin.seasons.items.create', $scopedSeason) }}" class="btn btn-primary rounded-pill"><i class="bi bi-plus-lg me-1"></i> New Item in {{ $scopedSeason->code }}</a>
                        <a href="{{ route('admin.items.index') }}" class="btn btn-outline-primary rounded-pill">All Items</a>
                    @else
                        <a href="{{ route('admin.items.create') }}" class="btn btn-primary rounded-pill"><i class="bi bi-plus-lg me-1"></i> New Item</a>
                    @endif
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-primary rounded-pill">Back to Dashboard</a>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>SKU</th>
                                <th>Category</th>
                                <th>Season</th>
                                <th>Active</th>
                                <th class="text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td class="fw-semibold">{{ $item->name }}</td>
                                    <td>{{ $item->sku }}</td>
                                    <td>{{ $item->category?->name }}</td>
                                    <td>{{ $item->season?->code }}</td>
                                    <td><span class="badge {{ $item->is_active ? 'bg-primary' : 'bg-secondary' }}">{{ $item->is_active ? 'Yes' : 'No' }}</span></td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.items.edit', $item) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="card-footer bg-white">{{ $items->links() }}</div>
            </div>
        </div>
    </section>
</x-app-layout>


