#!/bin/bash

# Laravel Livewire Bootstrap Base - Test Runner
# This script runs all tests for the application

echo "🧪 Running Laravel Livewire Bootstrap Base Tests"
echo "=================================================="

# Set up test database
echo "📊 Setting up test database..."
php artisan migrate --env=testing

# Run all tests
echo "🚀 Running all tests..."
php artisan test

# Run specific test suites
echo ""
echo "📋 Running individual test suites:"
echo ""

echo "🔐 Authentication Tests:"
php artisan test tests/Feature/AuthTest.php

echo ""
echo "👤 User Role Tests:"
php artisan test tests/Feature/UserRoleTest.php

echo ""
echo "⚡ Livewire Tests:"
php artisan test tests/Feature/LivewireTest.php

echo ""
echo "🗄️ Database Tests:"
php artisan test tests/Feature/DatabaseTest.php

echo ""
echo "🎨 Bootstrap Tests:"
php artisan test tests/Feature/BootstrapTest.php

echo ""
echo "🛣️ Route Tests:"
php artisan test tests/Feature/RouteTest.php

echo ""
echo "🔗 Integration Tests:"
php artisan test tests/Feature/IntegrationTest.php

echo ""
echo "✅ All tests completed!"
echo "=================================================="
