<?php

namespace App\Livewire\Finance;

use Livewire\Component;
use App\Models\Statement;
use App\Models\StatementTransaction;
use App\Models\TransactionMatch;

class StatementReview extends Component
{
    public Statement $statement;

    public function mount(int $statementId)
    {
        $this->statement = Statement::with(['transactions.matches.receipt'])->findOrFail($statementId);
    }

    public function render()
    {
        return view('livewire.finance.statement-review');
    }
}


