# Payment Enforcement System

## Overview

The payment enforcement system automatically pauses user accounts that have payment issues for more than 7 days. This ensures that only paying customers continue to have access to their galleries while giving them a grace period to resolve payment issues.

## How It Works

### Automatic Enforcement Rules

1. **Who Gets Checked:**
   - Users on paid tiers (Professional, Business)
   - Active subscriptions (not already paused or canceled)

2. **Who Is Exempt:**
   - Superusers (always exempt)
   - Users with "Skip Payment Enforcement" enabled (admin override)
   - Free/Starter tier users
   - Users already paused or canceled

3. **Grace Period:**
   - When a payment issue is first detected, a 7-day grace period begins
   - Users can continue to use their account during this grace period
   - If payment is resolved within 7 days, the grace period is cleared
   - If payment is not resolved after 7 days, the account is automatically paused

### Payment Issues Detected

The system checks for:
- No Stripe customer account
- No active Stripe subscription
- Subscription status is not 'active' or 'trialing'
- Subscription retrieval errors

## Admin Override

### Enabling Skip Payment Enforcement

Admins can exempt specific users from automatic payment enforcement:

1. Go to Superuser → Users → [Select User]
2. Scroll to "💳 Payment Enforcement" section
3. Check "Skip Payment Enforcement"
4. The change is saved automatically

**When to use this:**
- VIP customers with special arrangements
- Partner/affiliate accounts
- Test accounts
- Users with manual billing agreements

**Warning:** Users with this enabled will NEVER be paused for payment issues, even if they have no payment information.

## Running the Enforcement Script

### Manual Run

```bash
node enforce-payment.js
```

### Automated via Cron (Recommended)

Add to your crontab to run daily at 2 AM:

```bash
# Edit crontab
crontab -e

# Add this line:
0 2 * * * cd /path/to/VybePhoto && node enforce-payment.js >> logs/payment-enforcement.log 2>&1
```

### Script Output

The script provides detailed output:
- How many users were checked
- Individual user status (valid, grace period, paused)
- Grace period expiration dates
- Any errors encountered

Example output:
```
========================================
Payment Enforcement Check
2025-11-10T02:00:00.000Z
========================================

Found 15 users on paid tiers to check.

[1/15] Checking user: john-smith (ID: 5)
  ✓ Valid payment

[2/15] Checking user: jane-doe (ID: 7)
  ⚠️  Subscription status: past_due
  ⏰ Grace period set until: 11/17/2025, 2:00:00 AM
     Reason: invalid_payment

[3/15] Checking user: bob-photo (ID: 12)
  ⚠️  No Stripe subscription ID
  ⏰ Grace period expires in 1 days (11/11/2025, 2:00:00 AM)

[4/15] Checking user: alice-studios (ID: 18)
  ⚠️  Subscription status: canceled
  ⏸️  PAUSED: alice-studios
     Reason: Payment issue detected for more than 7 days

========================================
Payment Enforcement Complete
========================================
Total users checked: 15
Valid payments: 10
In grace period: 3
Paused: 2
========================================
```

## Monitoring

### Via Superuser Dashboard

1. Go to Superuser → Users
2. Look at the "Stripe Info" column
3. Users in grace period will show their expiration date
4. Paused users will show "PAUSED" status

### Via Subscription Audit

1. Go to Superuser → Subscription Audit
2. Review discrepancies between database and Stripe
3. Identify users with payment issues

### Via User Edit Page

When viewing a specific user (Superuser → Users → [User]):
- The "Payment Enforcement" section shows current status
- If a grace period is active, it displays the expiration date
- You can toggle the override from this page

## Reactivating Paused Accounts

### If Payment Issue Is Resolved

The user's subscription status will be updated automatically via Stripe webhooks when they update their payment method or subscription is renewed.

### Manual Reactivation

If you need to manually reactivate an account:

1. Go to Superuser → Users → [Select User]
2. Scroll to "Subscription Details"
3. Use "Change Subscription Tier" to update status
4. Or click "Activate Account" in "Administrative Actions"

## Best Practices

1. **Monitor Regularly:** Check the payment enforcement logs daily
2. **Set Up Webhooks:** Ensure Stripe webhooks are configured to automatically update subscription statuses
3. **Notify Users:** Consider adding email notifications when users enter grace period (see TODO in `enforce-payment.js`)
4. **Use Override Sparingly:** Only exempt users from enforcement when absolutely necessary
5. **Document Overrides:** Add notes in the admin log when manually overriding payment enforcement

## Database Schema

New columns added to `users` table:

```sql
skip_payment_enforcement BOOLEAN NOT NULL DEFAULT FALSE
last_payment_check_at TIMESTAMP
payment_grace_period_ends TIMESTAMP
```

## Security Considerations

- Only superusers can toggle payment enforcement
- All changes are logged in the admin audit log
- The enforcement script cannot pause superusers
- Grace periods are tracked per-user to prevent repeated warnings

## Troubleshooting

### Script Doesn't Pause Anyone

- Check if Stripe is configured (`STRIPE_SECRET_KEY` in `.env`)
- Verify users have `stripe_customer_id` and `stripe_subscription_id`
- Check if grace periods are still active
- Ensure users are not marked as `skip_payment_enforcement`

### False Positives

If users are being paused incorrectly:
- Verify Stripe webhook configuration
- Check if subscription status is updating correctly
- Review Stripe Dashboard for actual payment status
- Use "Skip Payment Enforcement" for legitimate cases

### Can't Toggle Override

- Ensure you're logged in as superuser
- Check browser console for errors
- Verify database migration ran successfully (`skip_payment_enforcement` column exists)

## Future Enhancements

- [ ] Email notifications when grace period starts
- [ ] Email notifications 2 days before pause
- [ ] Email notification when account is paused
- [ ] Dashboard widget showing users in grace period
- [ ] Automatic retry of failed payments
- [ ] Custom grace period per tier


