<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Imports\StatementImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class StatementImportController extends Controller
{
    public function import(Request $request)
    {
        $request->validate([
            'file' => ['required', 'file', 'mimes:xlsx,csv,txt'],
            'cardholder_name' => ['nullable', 'string'],
            'account_number_last4' => ['nullable', 'string'],
            'statement_cycle' => ['nullable', 'string'],
        ]);

        Excel::import(new StatementImport(
            $request->input('cardholder_name'),
            $request->input('account_number_last4'),
            $request->input('statement_cycle')
        ), $request->file('file'));

        return response()->json(['status' => 'ok']);
    }
}


