<?php
$meta = [
  'title' => 'IT Infrastructure Modernisation | Case Study',
  'description' => 'Managed devices, networks, vendors and upgrades across mixed OS environments to support growth.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/it-infrastructure-modernisation.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">IT Infrastructure Modernisation</h1>
    <p class="mt-2 text-sm text-gray-600">Windows · macOS · Linux · ChromeOS; vendor coordination</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Responsibilities</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>Device lifecycle management and procurement with external suppliers.</li>
          <li>Network upgrades including Wi‑Fi reliability improvements.</li>
          <li>Documentation, training and support for 30+ staff.</li>
        </ul>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Outcome</h2>
        <p class="mt-2 text-sm text-gray-700">Fewer drop‑outs, faster support, and happier teams; systems aligned with business growth.</p>
      </div>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


