# Fix Gallery URLs in Production

## Problem
Gallery URLs in the admin panel are pointing to `https://admin.vybephoto.com/a/CODE` instead of `https://username.vybephoto.com/a/CODE`.

## Root Cause
The production deployment is missing the `BASE_DOMAIN` and `APP_SUBDOMAIN` environment variables.

## Solution

### 1. Update Cloud Run Environment Variables

Run this command to update your Cloud Run service:

```bash
gcloud run services update nrw-web \
  --region=europe-west1 \
  --set-env-vars="BASE_DOMAIN=vybephoto.com,APP_SUBDOMAIN=app"
```

### 2. Update Your DNS

Make sure you have these DNS records in Cloudflare:

| Type  | Name | Target                    | Proxy |
|-------|------|---------------------------|-------|
| CNAME | *    | your-service.run.app      | ON    |
| CNAME | app  | your-service.run.app      | ON    |

### 3. Access the Admin Panel Correctly

**OLD (Wrong):** `https://admin.vybephoto.com/admin`  
**NEW (Correct):** `https://app.vybephoto.com/admin`

The app subdomain is where photographers log in and manage their galleries.

### 4. Test the Fix

1. Go to `https://app.vybephoto.com/login`
2. Log in with your credentials
3. Go to Admin → Albums
4. Click "View Album →" link
5. The URL should be `https://your-username.vybephoto.com/a/CODE`

## Architecture Recap

```
app.vybephoto.com          → Photographer login & admin panel (server-multi-tenant.js)
username.vybephoto.com     → Client-facing photo gallery
customdomain.com           → Custom domain (for Professional/Business tiers)
```

## Complete Environment Variables for Production

```bash
gcloud run services update nrw-web \
  --region=europe-west1 \
  --set-env-vars="\
USE_POSTGRES=true,\
USE_CLOUD_STORAGE=true,\
GCS_BUCKET_NAME=your-bucket-name,\
DB_NAME=photowebsite,\
DB_USER=postgres,\
INSTANCE_UNIX_SOCKET=/cloudsql/PROJECT_ID:REGION:DB_INSTANCE,\
BASE_DOMAIN=vybephoto.com,\
APP_SUBDOMAIN=app"
```

## Quick Fix (If You Can't Wait)

If you can't redeploy right now, you can add this redirect in Cloudflare:

**Page Rule:**
- URL: `https://admin.vybephoto.com/*`
- Setting: Forwarding URL (301 - Permanent Redirect)
- Destination: `https://app.vybephoto.com/$1`

This will redirect anyone using the old admin.vybephoto.com URL to the correct app.vybephoto.com.

