<?php

namespace App\Http\Controllers;

use App\Contracts\ProfileService;
use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function __construct(private readonly ProfileService $profiles)
    {
        $this->middleware('auth');
    }

    public function edit(Request $request)
    {
        $user = $request->user();
        $profile = $user->profile;
        return view('profile.edit', compact('user', 'profile'));
    }

    public function update(ProfileUpdateRequest $request): RedirectResponse
    {
        $this->profiles->updateProfile($request->user(), $request->validated());
        return back()->with('status', 'Profile updated');
    }
}


