# Admin Panel Access Guide

## Quick Start

Your Vybe Photo admin panel is running and ready to use!

### Login Information

**URL:** http://app.localhost:3000/login

**Default Admin Account:**
- Email: `admin@vybephoto.com`
- Password: `admin123456`
- Username: `admin`

**Test Photographer Account:**
- Email: `test@example.com`
- Password: `admin123456` (if set with default)
- Username: `test-photographer`

### Important URLs

| Page | URL | Description |
|------|-----|-------------|
| Login | http://app.localhost:3000/login | Sign in page |
| Dashboard | http://app.localhost:3000/dashboard | Your main dashboard with usage stats |
| Admin | http://app.localhost:3000/admin | Full admin interface for managing albums |
| Settings | http://app.localhost:3000/admin/settings | Site configuration and branding |
| Superuser Portal | http://app.localhost:3000/superuser | Admin-only: Manage all users and tiers |

### Your Public Gallery

After logging in as admin, your public gallery is accessible at:
- http://admin.localhost:3000 (subdomain based on your username)

### Features Available in Admin Panel

#### Album Management
- Create new albums
- Upload photos (supports bulk upload up to 500 photos)
- Drag and drop to reorder photos
- Set albums as public or private
- Assign access codes for private albums
- Delete albums and photos

#### Photo Organization
- Create groups to organize multiple albums
- Drag and drop to reorder albums on homepage
- Set featured "home page album"
- Configure download permissions

#### Branding & Settings
- Upload custom logo
- Set primary brand color
- Configure social media links
- Set contact email
- Enable/disable age verification
- Configure "Hot Chocolate" donation buttons

#### Advanced (Superuser Only)
- Manage all user accounts
- Create custom subscription tiers
- View revenue statistics
- Access audit logs
- Manually adjust user limits

## Architecture Notes

This is a **multi-tenant SaaS platform**:

- `app.localhost:3000` = Login/Dashboard/Admin area for photographers
- `username.localhost:3000` = Individual photographer galleries
- `www.localhost:3000` = Main marketing site (handled separately)

## Troubleshooting

### Can't access admin?
1. Make sure you're at `http://app.localhost:3000` (not just `localhost:3000`)
2. Log in first at `/login`
3. Then navigate to `/admin`

### Forgot password?
Run this script to reset the admin password:
```bash
npm run setup:multi
```

Or manually reset in PostgreSQL:
```bash
node setup-superuser-auto.js
```

### Server not running?
Start the multi-tenant server:
```bash
npm run start:multi
# or for development with auto-reload:
npm run dev:multi
```

### Database errors?
Check PostgreSQL is running and the database exists:
```bash
psql -U postgres -d photowebsite -c "SELECT COUNT(*) FROM users;"
```

## Security Notes

⚠️ **Change the default password after first login!**

The default credentials are:
- Username: `admin`
- Password: `admin123456`

This is fine for local development but should be changed before deploying to production.

## Next Steps

1. Login at http://app.localhost:3000/login
2. Create your first album at http://app.localhost:3000/admin
3. Upload some photos
4. Visit your public gallery at http://admin.localhost:3000 to see it live!

Enjoy using Vybe Photo! 📸

