<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('total_cache', function (Blueprint $table) {
            $table->id();
            $table->enum('entity_type', ['shipment_line', 'customer_order_line', 'customer_order', 'shipment']);
            $table->unsignedBigInteger('entity_id');
            $table->string('cache_key', 255);
            $table->json('cached_data');
            $table->timestamp('fresh_at')->nullable();
            $table->timestamps();
            
            // Unique constraint to prevent duplicate cache entries
            $table->unique(['entity_type', 'entity_id', 'cache_key'], 'unique_entity_cache');
            
            // Indexes for performance
            $table->index(['entity_type', 'entity_id'], 'idx_entity');
            $table->index('fresh_at', 'idx_fresh');
            $table->index(['entity_type', 'fresh_at'], 'idx_entity_fresh');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('total_cache');
    }
};