@extends('layouts.shop')

@section('title', 'Returns Policy - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Returns Policy</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <h3 class="fw-bold mb-3">Our Returns Policy</h3>
                <p>We want you to be completely satisfied with your purchase. If you're not happy, we're here to help.</p>

                <h4 class="fw-bold mt-4 mb-3">Returns Within 14 Days</h4>
                <p>You have 14 days from receipt of your order to return items for a refund or exchange.</p>
                
                <h5 class="fw-bold mt-3">Items must be:</h5>
                <ul>
                    <li>Unused and in original condition</li>
                    <li>In original packaging with labels attached</li>
                    <li>In the same dye lot (for yarn)</li>
                </ul>

                <h4 class="fw-bold mt-4 mb-3">How to Return</h4>
                <ol>
                    <li>Contact us at info@yarnstore.co.uk with your order number</li>
                    <li>We'll provide return authorization and instructions</li>
                    <li>Pack items securely in original packaging</li>
                    <li>Ship to the address provided</li>
                </ol>

                <h4 class="fw-bold mt-4 mb-3">Return Shipping</h4>
                <p>Customers are responsible for return shipping costs unless:</p>
                <ul>
                    <li>The item is defective</li>
                    <li>We sent the wrong item</li>
                    <li>The item arrived damaged</li>
                </ul>

                <h4 class="fw-bold mt-4 mb-3">Refunds</h4>
                <p>Refunds will be processed within 5-7 business days of receiving your return.</p>
                <p>Refunds will be issued to the original payment method.</p>

                <h4 class="fw-bold mt-4 mb-3">Exchanges</h4>
                <p>If you need a different color or quantity, please place a new order and return the unwanted items.</p>

                <h4 class="fw-bold mt-4 mb-3">Damaged or Defective Items</h4>
                <p>Please contact us immediately if you receive damaged or defective items. We'll arrange for replacement or refund at no cost to you.</p>

                <div class="mt-4 p-3" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
                    <h5 class="fw-bold mb-2">Questions?</h5>
                    <p class="mb-2">Contact us at info@yarnstore.co.uk or call 01234 567890</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



