<?php

namespace App\Livewire\Forms;

use Exception;
use Throwable;
use Livewire\Form;
use App\Models\Price;
use App\Models\Sizes;
use App\Helper\Functions;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use App\Models\ShipmentLineSizes;
use App\Models\CustomerOrderFiles;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Storage;
use App\Models\CustomerOrderLineQuantities;

class OrdersEditForm extends Form
{
	public ?CustomerOrders $order;

	public $orderEdit, $uploadFiles = [], $removeItems = [], $removeDrops = [], $removeSizes = [], $new = FALSE, $sizes;

	public function rules()
    {
        return [
			'orderEdit.department_id' => 'required_if:new,1|numeric|min:1',
			'orderEdit.seasons_id' => 'required|numeric|min:1',
			'orderEdit.customers_id' => 'required|numeric|min:1',
			'orderEdit.incoterms' => 'required|in:EXW,FCA,CPT,CIP,DAP,DPU,DDP,FAS,FOB,CFR,CIF',
			'orderEdit.customer_addresses_id' => 'nullable|numeric|min:1',
			'orderEdit.customer_po' => 'required|string|max:35',
			'orderEdit.cust_ship_no' => 'nullable|string|max:35',
			'orderEdit.order_date' => 'required|date',
			'orderEdit.sent_to_factory' => 'nullable|date',
			'orderEdit.incomplete_flag' => 'required|boolean',
			'orderEdit.shipment_mode' => 'nullable|string|max:30',

			'orderEdit.customer_order_lines.*.colourways_id' => 'required|numeric|min:1',
			'orderEdit.customer_order_lines.*.location' => '',
			'orderEdit.customer_order_lines.*.factory_cust_date' => '',
			'orderEdit.customer_order_lines.*.wh_cust_date' => '',
			'orderEdit.customer_order_lines.*.start_knit' => '',
			'orderEdit.customer_order_lines.*.colour_approved_date' => '',
			'orderEdit.customer_order_lines.*.lab_dips_sent' => '',
			'orderEdit.customer_order_lines.*.colour_approval_comments' => '',
			'orderEdit.customer_order_lines.*.notes' => '',
			'orderEdit.customer_order_lines.*.cp_notes' => '',

			// 'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.sizes_id' => 'required|numeric|min:1',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.price' => 'nullable|numeric|min:0',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.discount' => 'nullable|numeric|min:0|max:100',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.commission' => 'nullable|numeric|min:0|max:100',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.qty' => 'nullable|numeric',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.SKU' => 'nullable|string|max:35',
			'orderEdit.customer_order_lines.*.customer_order_line_quantities.*.barcode' => 'nullable|string|max:35',

			'orderEdit.customer_order_lines.*.shipment_lines.*.exfty' => 'required|date',

			'orderEdit.customer_order_lines.*.shipment_lines.*.shipment_line_sizes.*.qty' => 'nullable|numeric',
			'orderEdit.customer_order_lines.*.shipment_lines.*.shipment_line_sizes.*.shipped_qty' => 'nullable|numeric',
        ];
    }


	public function open($order = NULL, $commission = FALSE){
        $this->sizes = Sizes::all();

		if(!empty($order)){
			$this->order = $order;
            foreach($order->customer_order_lines as $l=>$line){
                foreach($line->customer_order_line_quantities as $q=>$qty){
                    $order->customer_order_lines[$l]->customer_order_line_quantities[$q]->size = $this->sizes->where('id', $qty->sizes_id)->first()->name;
                }
            }
			$this->orderEdit = $order->toArray();
		}
		else{
			$this->order = null;
			$this->orderEdit = [];
            if($commission)
                $this->orderEdit['order_type'] = 'commission';
			$this->orderEdit['incomplete_flag'] = 0;
			$this->orderEdit['cancelled'] = 0;
		}
	}

    public function totalOrderLineValue($line){
		$i = 0;
		foreach($line['customer_order_line_quantities'] as $lineQuantity){
            if(!empty($lineQuantity['sizes_id']) && !empty($lineQuantity['qty'])){
                // Use price resolution cache instead of Functions::getPrice()
                // Create a temporary quantity object to get price model
                $tempQuantity = new \App\Models\CustomerOrderLineQuantities;
                $tempQuantity->customer_order_lines_id = $line['id'];
                $tempQuantity->sizes_id = $lineQuantity['sizes_id'];
                
                // Create a mock customer order line with colourway data
                $tempOrderLine = new \App\Models\CustomerOrderLines;
                $tempOrderLine->id = $line['id'];
                $tempOrderLine->colourways_id = $line['colourways_id'];
                $tempOrderLine->phase_id = $line['phase_id'] ?? null;
                
                // Create a mock colourway
                $tempColourway = new \App\Models\Colourways;
                $tempColourway->id = $line['colourways_id'];
                $tempColourway->style_versions_id = $line['colourways']['style_versions_id'];
                $tempColourway->colour_type = $line['colourways']['colour_type'];
                
                // Create a mock customer order
                $tempCustomerOrder = new \App\Models\CustomerOrders;
                $tempCustomerOrder->seasons_id = $line['customer_orders']['seasons_id'] ?? 1;
                
                $tempOrderLine->colourways = $tempColourway;
                $tempOrderLine->customer_orders = $tempCustomerOrder;
                $tempQuantity->customer_order_lines = $tempOrderLine;
                
                $priceModel = $tempQuantity->price_model;
                if($priceModel && isset($priceModel['quote'])){
                    $i = $i + ($priceModel['quote'] * $lineQuantity['qty']);
                }
            }
		}
		return number_format((float) $i, 2, '.', '');
	}

    public function totalOrderValue(){
        $i = 0;
        foreach($this->orderEdit['customer_order_lines'] ?? [] as $line){
            $i = $i + $this->totalOrderLineValue($line);
        }
        return number_format((float) $i, 2, '.', '');
    }


	public function save(){
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving - check size qtys are filled in');
		session()->flash('alert-class', 'alert-danger');

		foreach($this->removeItems as $item){
			CustomerOrderLines::find($item)?->delete();
		}
		foreach($this->removeDrops as $drop){
			ShipmentLine::find($drop)?->delete();
		}
		foreach($this->removeSizes as $size){
			CustomerOrderLineQuantities::find($size['colq'])?->delete();
			foreach($size['sls'] as $remove){
				ShipmentLineSizes::find($remove)?->delete();
			}
		}

		if(!empty($this->order)){
			$order = $this->order;
            $newOrderFlag = FALSE;
		}
		else{
			$order = new CustomerOrders;
            $newOrderFlag = TRUE;
		}
		$order->departments_id        = $this->orderEdit['departments_id'];
		$order->seasons_id            = $this->orderEdit['seasons_id'];
		$order->customers_id          = $this->orderEdit['customers_id'];
		$order->incoterms             = $this->orderEdit['incoterms'];
		$order->customer_addresses_id = $this->orderEdit['customer_addresses_id'] ?? NULL;
		$order->customer_po           = $this->orderEdit['customer_po'] ?? NULL;
		$order->cust_ship_no          = $this->orderEdit['cust_ship_no'] ?? NULL;
		$order->order_date            = $this->orderEdit['order_date'] ?? NULL;
		$order->sent_to_factory       = $this->orderEdit['sent_to_factory'] ?? NULL;
		$order->incomplete_flag       = $this->orderEdit['incomplete_flag'];
		$order->order_type            = $this->orderEdit['order_type'] ?? "wholesale";
		$order->cancelled             = $this->orderEdit['cancelled'];
		$order->shipment_mode         = $this->orderEdit['shipment_mode'];
		$order->save();

        try {

            if($this->uploadFiles != []){
                foreach($this->uploadFiles as $file){
                    $path = NULL;
                    $entry = new CustomerOrderFiles();
                    $path = Storage::disk('public')->put('customerOrderFiles', $file);
                    if($path != NULL){
                        $entry->customer_orders_id = $order->id;
                        $entry->filename = $file->getClientOriginalName();
                        $entry->file = $path;
                        $entry->save();
                    }
                }
            }

            foreach($this->orderEdit['customer_order_lines'] ?? [] as $l=>$line){
                if(!empty($line['id'])){
                    $orderLine = CustomerOrderLines::firstOrNew(['id' => $line['id']]);
                }
                else{
                    $orderLine = new CustomerOrderLines;
                }
                // dd($line['wh_cust_date'], $line['factory_cust_date']);
                $orderLine->customer_orders_id = $order->id;
                $orderLine->colourways_id = $line['colourways_id'];
                $orderLine->location = $line['location'] ?? NULL;
                $orderLine->factory_cust_date = !empty($line['factory_cust_date']) ? $line['factory_cust_date'] : NULL;
                $orderLine->wh_cust_date = !empty($line['wh_cust_date']) ? $line['wh_cust_date'] : NULL;
                $orderLine->start_knit = !empty($line['start_knit']) ? $line['start_knit'] : NULL;
                $orderLine->colour_approved_date = !empty($line['colour_approved_date']) ? $line['colour_approved_date'] : NULL;
                $orderLine->lab_dips_sent_date = !empty($line['lab_dips_sent_date']) ? $line['lab_dips_sent_date'] : NULL;
                $orderLine->colour_approval_comments = $line['colour_approval_comments'] ?? NULL;
                $orderLine->notes = $line['notes'] ?? NULL;
                $orderLine->cp_notes = $line['cp_notes'] ?? NULL;
                $orderLine->save();

                foreach($line['customer_order_line_quantities'] ?? [] as $q=>$qty){

                    if(($qty['sizes_id'] = $this->sizes->where('name', $qty['size'])->first()?->id) == NULL){
                        $qty['sizes_id'] = Sizes::firstOrCreate([
                            'name' => $qty['size'],
                        ])->id;
                    }



                    if(!empty($qty['id'])){
                        $quantity = CustomerOrderLineQuantities::firstOrNew(['id' => $qty['id']]);
                    }
                    else{
                        $quantity = new CustomerOrderLineQuantities;
                    }

                    $quantity->customer_order_lines_id = $orderLine->id;
                    $quantity->sizes_id = $qty['sizes_id'];
                    $quantity->price = $qty['price'] ?? 0;
                    $quantity->discount = $qty['discount'] ?? 0;
                    $quantity->commission = $qty['commission'] ?? 0;
                    $quantity->qty = $qty['qty'] ?? 0;
                    $quantity->SKU = $qty['SKU'] ?? NULL;
                    $quantity->barcode = $qty['barcode'] ?? NULL;
                    $quantity->save();
                }

                foreach($line['shipment_lines'] ?? [] as $sl=>$shipmentLine){
                    if(!empty($shipmentLine['id'])){
                        $drop = ShipmentLine::firstOrNew(['id' => $shipmentLine['id']]);
                    }
                    else{
                        $drop = new ShipmentLine;
                    }

                    $drop->customer_order_lines_id = $orderLine->id;
                    if(empty($drop->exfty))
                        $drop->first_exfty = $shipmentLine['exfty'];
                    $drop->exfty = $shipmentLine['exfty'];
                    $drop->save();

                    $drop->shipment_line_sizes()->forceDelete();
                    // dd($drop, ShipmentLineSizes::where('shipment_line_id', $drop->id)->get(), $line['customer_order_line_quantities']);

                    foreach($line['customer_order_line_quantities'] as $q=>$qty){
                        $quantity = new ShipmentLineSizes;
                        $quantity->shipment_line_id = $drop->id;
                        $quantity->sizes_id = Sizes::where('name', $qty['size'])->first()->id;
                        if(count($line['shipment_lines']) == 1){
                            $quantity->qty = $qty['qty'] ?? 0;
                        }
                        else{
                            $quantity->qty = $shipmentLine['shipment_line_sizes'][$q]['qty'] ?? 0;
                        }
                        // dd($line, $drop, $shipmentLine['shipment_line_sizes'][$q]['qty']);
                        $quantity->shipped_qty = empty($shipmentLine['shipment_line_sizes'][$q]['shipped_qty']) ? 0 : $shipmentLine['shipment_line_sizes'][$q]['shipped_qty'] ?? 0;
                        $quantity->save();
                    }
                }
            }

            session()->flash('message', 'Style Information Saved');
            session()->flash('alert-class', 'alert-success');
            return true;
        } catch (Throwable $e) {
            if($newOrderFlag)
                $order->delete();
            report($e);

            return false;
        }


	}
}
