<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    public const STORE_APPLE = 'apple';
    public const STATUS_ACTIVE = 'active';
    public const STATUS_IN_GRACE = 'in_grace';
    public const STATUS_EXPIRED = 'expired';
    public const STATUS_CANCELED = 'canceled';

    protected $fillable = [
        'user_id', 'store', 'product_id', 'status', 'period_end_at', 'latest_receipt',
    ];

    protected $casts = [
        'period_end_at' => 'datetime',
        'latest_receipt' => 'array',
    ];
}


