<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4>Welcome to Laravel Livewire Store</h4>
                </div>
                <div class="card-body">
                    @auth
                        <div class="alert alert-success">
                            <h5>Hello, {{ $user->name }}!</h5>
                            <p>You are logged in as: <strong>{{ ucfirst($user->role) }}</strong></p>
                            @if($user->isAdmin())
                                <p class="text-info">You have admin privileges and can manage the store.</p>
                            @else
                                <p class="text-muted">You can browse and purchase items from our store.</p>
                            @endif
                        </div>
                    @else
                        <div class="alert alert-info">
                            <h5>Welcome to our Store!</h5>
                            <p>Please <a href="{{ route('login') }}">login</a> or <a href="{{ route('register') }}">register</a> to get started.</p>
                        </div>
                    @endauth
                    
                    <div class="mt-4">
                        <h6>Features Available:</h6>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">✅ Laravel 12 with Livewire 3</li>
                            <li class="list-group-item">✅ Bootstrap 5 UI Framework</li>
                            <li class="list-group-item">✅ PostgreSQL Database</li>
                            <li class="list-group-item">✅ User Authentication System</li>
                            <li class="list-group-item">✅ Role-based Access (User/Admin)</li>
                            <li class="list-group-item">✅ Responsive Design</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
