<?php

namespace App\Jobs;

use App\Models\Receipt;
use App\Services\Matching\ReceiptMatchingService;
use App\Jobs\ClassifyTransaction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MatchReceipt implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 120;

    public function __construct(public int $receiptId) {}

    public function handle(ReceiptMatchingService $matchingService): void
    {
        $receipt = Receipt::find($this->receiptId);
        if (!$receipt) return;
        $matchingService->attemptMatchForReceipt($receipt);

        // After matching, re-classify the linked transaction (if any)
        $receipt->refresh();
        $match = $receipt->matches()->first();
        if ($match && $match->statement_transaction_id) {
            ClassifyTransaction::dispatch($match->statement_transaction_id);
        }
    }
}


