<?php

namespace App\Jobs;

use App\Models\Receipt;
use App\Services\Matching\ReceiptMatchingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MatchReceipt implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 60; // Reduced timeout for faster processing
    public int $maxExceptions = 2; // Fail faster on repeated exceptions

    public function __construct(public int $receiptId) {}

    public function handle(ReceiptMatchingService $matchingService): void
    {
        $receipt = Receipt::find($this->receiptId);
        if (!$receipt) return;
        $matchingService->attemptMatchForReceipt($receipt);
    }
}


