<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Receipt;
use App\Models\ReceiptLine;
use App\Models\ClassificationRule;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Receipt::saved(function (Receipt $receipt) {
            if ($receipt->wasChanged(['department_id', 'account_id', 'is_personal']) && $receipt->merchant_name) {
                ClassificationRule::create([
                    'pattern' => $receipt->merchant_name,
                    'scope' => 'merchant',
                    'department_id' => $receipt->department_id,
                    'account_id' => $receipt->account_id,
                    'is_personal' => (bool)$receipt->is_personal,
                    'weight' => 2,
                    'user_id' => $receipt->user_id,
                ]);
            }
        });

        ReceiptLine::saved(function (ReceiptLine $line) {
            if ($line->wasChanged(['department_id', 'account_id', 'is_personal']) && $line->description) {
                ClassificationRule::create([
                    'pattern' => $line->description,
                    'scope' => 'line_description',
                    'department_id' => $line->department_id,
                    'account_id' => $line->account_id,
                    'is_personal' => (bool)$line->is_personal,
                    'weight' => 2,
                    'user_id' => $line->receipt?->user_id,
                ]);
            }
        });
    }
}
