<?php
$meta = [
  'title' => 'Pricing | Straightforward plans',
  'description' => 'Straightforward pricing. Starter site, Business site, and Care plans with clear inclusions and fixed quotes.',
  'canonical' => 'https://neilwiddowson.co.uk/pricing/'
];
$currentPage = 'pricing';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Straightforward pricing.</h1>
    <p class="mt-3 text-gray-700">Every project gets a fixed quote after a quick call.</p>

    <!-- Websites -->
    <h2 class="mt-10 text-xl font-semibold text-gray-900">Professional Website Design <span class="badge badge-popular ml-2">Most popular</span></h2>
    <div class="pricing-group">
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Lightning Fast Single Page</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£199</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Mobile-first, lightning-fast loading</li>
          <li>Contact form & basic SEO included</li>
          <li>2 revisions & 1 week delivery</li>
          <li>Perfect for local businesses</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get started</a></div>
      </div>
      <div class="pricing-card pricing-featured">
        <h3 class="text-lg font-semibold text-gray-900">SEO-Optimized Business Site</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£799</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Up to 5 pages with advanced SEO</li>
          <li>Mobile-responsive & fast-loading</li>
          <li>4 revisions & professional copy</li>
          <li>Google Analytics & search optimization</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Build my site</a></div>
      </div>
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Custom Enterprise Solutions</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">Enquire for pricing</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Word-like easy editing system</li>
          <li>Event booking & custom plugins</li>
          <li>Advanced features & integrations</li>
          <li>Tailored to your business needs</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get custom quote</a></div>
      </div>
    </div>

    <!-- IT Support -->
    <h2 class="mt-12 text-xl font-semibold text-gray-900">IT Support</h2>
    <div class="pricing-group">
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Quick remote help</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£60 / hr</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>1‑hour minimum, same‑day if available</li>
          <li>Email, backups, Wi‑Fi, printers</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Book a slot</a></div>
      </div>
      <div class="pricing-card pricing-featured">
        <h3 class="text-lg font-semibold text-gray-900">Support block</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£220 / 4 hrs</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Use across a month</li>
          <li>Remote or on‑site mix</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get started</a></div>
      </div>
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">On‑site call‑out</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£50 + £60 / hr</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Within 20 miles of Killingworth</li>
          <li>Networks, hardware, installations</li>
          <li>Minimum 1 hour charge applies</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Book on-site visit</a></div>
      </div>
    </div>

    <!-- Website Care -->
    <h2 class="mt-12 text-xl font-semibold text-gray-900">Website Care</h2>
    <div class="pricing-group">
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Essential Care</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£20 / mo</p>
        <p class="text-sm text-gray-500">or £200 / year (save £40)</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Managed web hosting included</li>
          <li>Essential updates & security patches</li>
          <li>Daily backups & uptime monitoring</li>
          <li>No support included</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Choose Essential</a></div>
      </div>
      <div class="pricing-card pricing-featured">
        <h3 class="text-lg font-semibold text-gray-900">Plus Care <span class="badge badge-new ml-2">Most popular</span></h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">£40 / mo</p>
        <p class="text-sm text-gray-500">or £400 / year (save £80)</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Everything in Essential Care</li>
          <li>Fast support when you need it</li>
          <li>Image updates & text changes</li>
          <li>Up to 30 minutes work per month</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Choose Plus</a></div>
      </div>
    </div>

    <!-- Software Dev & AI -->
    <h2 class="mt-12 text-xl font-semibold text-gray-900">Software development & AI integrations</h2>
    <div class="pricing-group">
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">AI Workflow Automation</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">from £350 / day</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Connect systems & APIs seamlessly</li>
          <li>AI-powered task automation</li>
          <li>Eliminate repetitive manual work</li>
          <li>Boost team productivity & accuracy</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Start automation</a></div>
      </div>
      <div class="pricing-card pricing-featured">
        <h3 class="text-lg font-semibold text-gray-900">Custom Web Applications</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">from £995</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Replace clunky spreadsheets & forms</li>
          <li>Custom dashboards & data tools</li>
          <li>Secure user authentication</li>
          <li>Real-time data integration</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Build my app</a></div>
      </div>
    </div>

    <!-- Bitdefender -->
    <h2 class="mt-12 text-xl font-semibold text-gray-900">Bitdefender licensing</h2>
    <div class="pricing-group">
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Business pack</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">from £70 / yr</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>5 licences included</li>
          <li>Advanced business protection</li>
          <li>Remote setup & support</li>
        </ul>
          <div class="mt-auto pt-6"><a href="/bitdefender/business" class="btn-secondary w-full">More about business</a></div>
        </div>
        <div class="pricing-card pricing-featured">
          <h3 class="text-lg font-semibold text-gray-900">Family pack</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">from £75 / yr</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>15 devices covered</li>
            <li>Home & mobile protection</li>
            <li>Parental controls included</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/bitdefender/home" class="btn-secondary w-full">More about home</a></div>
      </div>
      <div class="pricing-card">
        <h3 class="text-lg font-semibold text-gray-900">Customised pricing</h3>
        <p class="mt-1 text-3xl font-bold text-gray-900">Contact for quote</p>
        <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
          <li>Advanced security options</li>
          <li>Enterprise features</li>
          <li>Managed services available</li>
        </ul>
        <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get custom quote</a></div>
      </div>
    </div>

    <p class="mt-6 text-xs text-gray-500">All prices are guide rates and exclude VAT if applicable. We'll confirm a fixed quote after a quick call.</p>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
