@extends('layouts.frontend')

@section('meta_title', 'Terms & Conditions - Yarn Store')
@section('meta_description', 'Read our terms and conditions for purchasing from Yarn Store by Robert Todd Yarn.')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <h1 class="display-5 fw-bold mb-4">Terms & Conditions</h1>
            <p class="text-muted mb-5">Last updated: {{ date('F d, Y') }}</p>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">1. Introduction</h2>
                <p class="text-muted">
                    Welcome to Yarn Store, operated by Robert Todd Yarn. These terms and conditions outline the rules and 
                    regulations for the use of our website and the purchase of products.
                </p>
                <p class="text-muted">
                    By accessing this website and placing orders, you accept these terms and conditions in full. 
                    Do not continue to use Yarn Store's website if you do not accept all of the terms and conditions stated on this page.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">2. Company Information</h2>
                <p class="text-muted">
                    <strong>Trading Name:</strong> Yarn Store<br>
                    <strong>Registered Business:</strong> Robert Todd Yarn<br>
                    <strong>Country:</strong> United Kingdom
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">3. Product Information & Pricing</h2>
                <p class="text-muted">
                    We strive to ensure all product descriptions and prices are accurate. However, errors may occur. 
                    If we discover an error in the price of products you have ordered, we will inform you as soon as possible 
                    and give you the option of reconfirming your order at the correct price or cancelling it.
                </p>
                <p class="text-muted">
                    All prices are in British Pounds (GBP) and include VAT at the current rate (20%).
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">4. Orders & Payment</h2>
                <p class="text-muted">
                    When you place an order, you are offering to purchase a product subject to these terms and conditions. 
                    All orders are subject to availability and confirmation of the order price.
                </p>
                <p class="text-muted">
                    Payment must be made in full before we dispatch your order. We accept payment by major credit and debit cards.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">5. Delivery</h2>
                <p class="text-muted">
                    We aim to dispatch orders within 2-3 working days. Delivery times may vary depending on your location 
                    and the delivery method chosen. We are not responsible for delays caused by third-party couriers.
                </p>
                <p class="text-muted">
                    Risk of loss and title for items purchased from our website pass to you upon delivery to the carrier.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">6. Returns & Refunds</h2>
                <p class="text-muted">
                    Under the Consumer Contracts Regulations 2013, you have the right to cancel your order within 14 days 
                    of receiving your goods without giving any reason.
                </p>
                <p class="text-muted">
                    To exercise your right to cancel, you must inform us of your decision. The goods must be returned in 
                    their original condition with all packaging intact. You will be responsible for the cost of returning the goods.
                </p>
                <p class="text-muted">
                    We will refund the price of the goods, excluding delivery charges, within 14 days of receiving the returned items.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">7. Limitation of Liability</h2>
                <p class="text-muted">
                    We do not exclude or limit in any way our liability to you where it would be unlawful to do so. 
                    This includes liability for death or personal injury caused by our negligence or fraud.
                </p>
                <p class="text-muted">
                    We are not liable for any losses that were not foreseeable to you and us when the contract was formed, 
                    or any losses that were not caused by any breach on our part.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">8. Intellectual Property</h2>
                <p class="text-muted">
                    All content on this website, including text, graphics, logos, images, and software, is the property of 
                    Robert Todd Yarn and is protected by UK and international copyright laws.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">9. Governing Law</h2>
                <p class="text-muted">
                    These terms and conditions are governed by and construed in accordance with the laws of England and Wales. 
                    Any disputes relating to these terms and conditions will be subject to the exclusive jurisdiction of the 
                    courts of England and Wales.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">10. Contact Us</h2>
                <p class="text-muted mb-3">
                    If you have any questions about these terms and conditions, please contact us:
                </p>
                <a href="{{ route('contact') }}" class="btn btn-ys-primary">
                    Contact Us
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

