#!/bin/bash

echo "🔍 Vybe Wellness App - 504 Error Debug Script"
echo "=============================================="

# Check if Laravel server is running
echo -e "\n1. Checking Laravel server status..."
if curl -s -o /dev/null -w "%{http_code}" http://127.0.0.1:8000 | grep -q "200"; then
    echo "✅ Laravel server is running on http://127.0.0.1:8000"
else
    echo "❌ Laravel server is not responding"
    echo "   Start with: php artisan serve --host=127.0.0.1 --port=8000"
    exit 1
fi

# Check Livewire components
echo -e "\n2. Checking Livewire components..."
if [ -f "app/Livewire/LibraryPage.php" ]; then
    echo "✅ LibraryPage.php exists"
else
    echo "❌ LibraryPage.php missing - creating..."
    php artisan make:livewire LibraryPage --force
fi

if [ -f "app/Livewire/CustomSessionForm.php" ]; then
    echo "✅ CustomSessionForm.php exists"
else
    echo "❌ CustomSessionForm.php missing - creating..."
    php artisan make:livewire CustomSessionForm --force
fi

if [ -f "app/Livewire/CustomSessionsList.php" ]; then
    echo "✅ CustomSessionsList.php exists"
else
    echo "❌ CustomSessionsList.php missing - creating..."
    php artisan make:livewire CustomSessionsList --force
fi

# Check view files
echo -e "\n3. Checking view files..."
if [ -f "resources/views/livewire/pages/library.blade.php" ]; then
    echo "✅ library.blade.php exists"
else
    echo "❌ library.blade.php missing"
fi

if [ -f "resources/views/livewire/custom-session-form.blade.php" ]; then
    echo "✅ custom-session-form.blade.php exists"
else
    echo "❌ custom-session-form.blade.php missing"
fi

if [ -f "resources/views/livewire/custom-sessions-list.blade.php" ]; then
    echo "✅ custom-sessions-list.blade.php exists"
else
    echo "❌ custom-sessions-list.blade.php missing"
fi

# Check routes
echo -e "\n4. Checking routes..."
echo "Web routes containing 'library':"
php artisan route:list | grep -i library || echo "   No library routes found"

echo "Web routes containing 'custom':"
php artisan route:list | grep -i custom || echo "   No custom routes found"

# Check for syntax errors
echo -e "\n5. Checking for PHP syntax errors..."
if php -l app/Livewire/LibraryPage.php 2>/dev/null; then
    echo "✅ LibraryPage.php syntax OK"
else
    echo "❌ LibraryPage.php has syntax errors"
fi

if php -l app/Livewire/CustomSessionForm.php 2>/dev/null; then
    echo "✅ CustomSessionForm.php syntax OK"
else
    echo "❌ CustomSessionForm.php has syntax errors"
fi

if php -l app/Livewire/CustomSessionsList.php 2>/dev/null; then
    echo "✅ CustomSessionsList.php syntax OK"
else
    echo "❌ CustomSessionsList.php has syntax errors"
fi

# Check Laravel logs
echo -e "\n6. Checking recent Laravel errors..."
if [ -f "storage/logs/laravel.log" ]; then
    echo "Recent errors from laravel.log:"
    tail -n 20 storage/logs/laravel.log | grep -i error || echo "   No recent errors found"
else
    echo "❌ laravel.log not found"
fi

# Check Livewire discovery
echo -e "\n7. Running Livewire discovery..."
php artisan livewire:discover

# Clear caches
echo -e "\n8. Clearing Laravel caches..."
php artisan optimize:clear

echo -e "\n🔧 Debug script completed!"
echo "Next steps:"
echo "1. Check the output above for missing files"
echo "2. Test the problematic pages again"
echo "3. Check browser console for JavaScript errors"
echo "4. Review Laravel logs for detailed error messages"
