<div class="card border-0 shadow-sm h-100 w-100">
    <!-- Component Controls Header -->
    <div class="card-header bg-gradient bg-primary text-white border-0">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
            <div class="d-flex align-items-center">
                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                    <i class="fas fa-chart-line fs-5"></i>
                </div>
                <div>
                    <h5 class="card-title mb-1 fw-bold">Customer Sales Progress</h5>
                    <small class="text-white-75">Shipped vs remaining sales by customer</small>
                </div>
            </div>
            
            <!-- Responsive Controls -->
            <div class="d-flex flex-wrap align-items-center gap-2">
                <div class="d-flex gap-2 flex-wrap">
                    <select 
                        wire:model.live="selectedSeason" 
                        id="season-filter"
                        class="form-select form-select-sm"
                        style="min-width: 140px;"
                        wire:loading.attr="disabled"
                    >
                        @foreach($seasons as $season)
                            <option value="{{ $season->id }}">{{ $season->description }}</option>
                        @endforeach
                    </select>
                    
                    <select 
                        wire:model.live="selectedOrderType" 
                        id="order-type-filter"
                        class="form-select form-select-sm"
                        style="min-width: 120px;"
                        wire:loading.attr="disabled"
                    >
                        @foreach($orderTypes as $value => $label)
                            <option value="{{ $value }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Refresh Button -->
                <button 
                    wire:click="refreshData" 
                    class="btn btn-outline-light btn-sm"
                    wire:loading.attr="disabled"
                    title="Refresh Data"
                >
                    <i class="fas fa-sync-alt" wire:loading.class="fa-spin"></i>
                    <span class="d-none d-sm-inline ms-1">Refresh</span>
                </button>
            </div>
        </div>
    </div>

    @if($isLoading)
        <!-- Loading State -->
        <div class="card-body bg-body-secondary border-bottom py-2">
            <div class="row text-center">
                <div class="col-4">
                    <div class="small text-muted">Shipped</div>
                    <div class="placeholder-glow">
                        <span class="placeholder col-6"></span>
                    </div>
                </div>
                <div class="col-4">
                    <div class="small text-muted">Remaining</div>
                    <div class="placeholder-glow">
                        <span class="placeholder col-6"></span>
                    </div>
                </div>
                <div class="col-4">
                    <div class="small text-muted">Customers</div>
                    <div class="placeholder-glow">
                        <span class="placeholder col-4"></span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                <table class="table table-hover mb-0 table-sm">
                    <thead class="sticky-top bg-body">
                        <tr>
                            <th class="border-0 py-2 px-3">Customer</th>
                            <th class="border-0 py-2 px-3 text-end">Shipped</th>
                            <th class="border-0 py-2 px-3 text-end">Remaining</th>
                            <th class="border-0 py-2 px-3 text-center">Progress</th>
                        </tr>
                    </thead>
                    <tbody>
                        @for($i = 0; $i < 8; $i++)
                            <tr>
                                <td class="py-2 px-3">
                                    <div class="d-flex align-items-center">
                                        <div class="placeholder-glow me-2">
                                            <span class="placeholder rounded-circle" style="width: 24px; height: 24px;"></span>
                                        </div>
                                        <div>
                                            <div class="placeholder-glow">
                                                <span class="placeholder col-8"></span>
                                            </div>
                                            <div class="placeholder-glow mt-1">
                                                <span class="placeholder col-4"></span>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-2 px-3 text-end">
                                    <div class="placeholder-glow">
                                        <span class="placeholder col-6"></span>
                                    </div>
                                </td>
                                <td class="py-2 px-3 text-end">
                                    <div class="placeholder-glow">
                                        <span class="placeholder col-6"></span>
                                    </div>
                                </td>
                                <td class="py-2 px-3 text-center">
                                    <div class="placeholder-glow mb-1">
                                        <span class="placeholder col-3"></span>
                                    </div>
                                    <div class="placeholder-glow">
                                        <span class="placeholder col-12" style="height: 4px;"></span>
                                    </div>
                                    <div class="placeholder-glow mt-1">
                                        <span class="placeholder col-4"></span>
                                    </div>
                                </td>
                            </tr>
                        @endfor
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Data loading is now handled in mount() method -->
    @elseif(empty($salesData))
        <div class="card-body text-center py-5">
            <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
            <h6 class="text-muted">No sales data</h6>
            <p class="text-muted small">No orders found for the selected season and order type.</p>
        </div>
    @else
        <!-- Enhanced Summary -->
        <div class="card-body bg-light border-bottom py-3">
            <div class="row g-3 text-center">
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-success mb-1">
                            <i class="fas fa-check-circle fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Shipped</div>
                        <div class="fw-bold text-success fs-5">£{{ number_format($totalSales, 0) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-warning mb-1">
                            <i class="fas fa-clock fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Remaining</div>
                        <div class="fw-bold text-warning fs-5">£{{ number_format(array_sum(array_column($salesData, 'remaining_sales')), 0) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-info mb-1">
                            <i class="fas fa-users fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Customers</div>
                        <div class="fw-bold text-info fs-5">{{ count($salesData) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-primary mb-1">
                            <i class="fas fa-percentage fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Avg Progress</div>
                        <div class="fw-bold text-primary fs-5">
                            {{ number_format(array_sum(array_column($salesData, 'shipping_percentage')) / count($salesData), 0) }}%
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Responsive Table -->
        <div class="card-body p-0 position-relative">
            <!-- Loading Overlay -->
            <div wire:loading.flex class="position-absolute top-0 start-0 w-100 h-100 align-items-center justify-content-center bg-white bg-opacity-50" style="z-index: 10;">
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <div class="mt-2 small text-muted">Loading data...</div>
                </div>
            </div>
            
            <!-- Desktop Table -->
            <div class="d-none d-lg-block">
                <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                    <table class="table table-hover mb-0">
                        <thead class="sticky-top bg-body border-bottom">
                            <tr>
                                <th class="border-0 py-3 px-4 fw-semibold text-muted">Customer</th>
                                <th class="border-0 py-3 px-4 fw-semibold text-muted text-end">Shipped</th>
                                <th class="border-0 py-3 px-4 fw-semibold text-muted text-end">Remaining</th>
                                <th class="border-0 py-3 px-4 fw-semibold text-muted text-center">Progress</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($salesData as $customerId => $data)
                                @php
                                    $shippingPercentage = $data['shipping_percentage'] ?? 0;
                                @endphp
                                <tr class="border-bottom">
                                    <td class="py-3 px-4">
                                        <div class="d-flex align-items-center">
                                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" 
                                                 style="width: 32px; height: 32px; font-size: 12px; font-weight: 600;">
                                                {{ substr($data['name'], 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ Str::limit($data['name'], 30) }}</div>
                                                <div class="badge bg-light text-dark" style="font-size: 0.75rem;">{{ $data['department'] }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-3 px-4 text-end">
                                        <div class="fw-bold text-success fs-6">£{{ number_format($data['shipped_sales'] ?? 0, 0) }}</div>
                                    </td>
                                    <td class="py-3 px-4 text-end">
                                        <div class="fw-bold text-warning fs-6">£{{ number_format($data['remaining_sales'] ?? 0, 0) }}</div>
                                    </td>
                                    <td class="py-3 px-4 text-center">
                                        <div class="fw-semibold text-muted mb-2">{{ number_format($shippingPercentage, 0) }}%</div>
                                        <div class="progress mb-2" style="height: 6px;">
                                            <div class="progress-bar bg-success" 
                                                 role="progressbar" 
                                                 style="width: {{ $shippingPercentage }}%">
                                            </div>
                                        </div>
                                        <div class="small text-muted">{{ number_format($data['shipped_drops'] ?? 0) }}/{{ number_format($data['total_drops'] ?? 0) }} drops</div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Mobile Cards -->
            <div class="d-lg-none">
                <div style="max-height: 500px; overflow-y: auto;">
                    @foreach($salesData as $customerId => $data)
                        @php
                            $shippingPercentage = $data['shipping_percentage'] ?? 0;
                        @endphp
                        <div class="border-bottom p-3">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" 
                                     style="width: 40px; height: 40px; font-size: 14px; font-weight: 600;">
                                    {{ substr($data['name'], 0, 1) }}
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold">{{ $data['name'] }}</div>
                                    <div class="badge bg-light text-dark">{{ $data['department'] }}</div>
                                </div>
                            </div>
                            
                            <div class="row g-3">
                                <div class="col-6">
                                    <div class="text-center p-2 bg-success bg-opacity-10 rounded">
                                        <div class="small text-muted mb-1">Shipped</div>
                                        <div class="fw-bold text-success">£{{ number_format($data['shipped_sales'] ?? 0, 0) }}</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 bg-warning bg-opacity-10 rounded">
                                        <div class="small text-muted mb-1">Remaining</div>
                                        <div class="fw-bold text-warning">£{{ number_format($data['remaining_sales'] ?? 0, 0) }}</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mt-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-semibold text-muted">Progress</span>
                                    <span class="fw-bold">{{ number_format($shippingPercentage, 0) }}%</span>
                                </div>
                                <div class="progress mb-2" style="height: 8px;">
                                    <div class="progress-bar bg-success" 
                                         role="progressbar" 
                                         style="width: {{ $shippingPercentage }}%">
                                    </div>
                                </div>
                                <div class="text-center small text-muted">
                                    {{ number_format($data['shipped_drops'] ?? 0) }}/{{ number_format($data['total_drops'] ?? 0) }} drops completed
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
</div>