<div class="card border-0 shadow-sm h-100">
    <!-- Modern Header -->
    <div class="card-header bg-gradient bg-primary text-white border-0">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
            <div class="d-flex align-items-center">
                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                    <i class="fas fa-chart-line fs-5"></i>
                </div>
                <div>
                    <h5 class="card-title mb-1 fw-bold">Customer Sales Progress</h5>
                    <small class="text-white-75">Shipped vs remaining sales by customer</small>
                </div>
            </div>
            
            <!-- Controls -->
            <div class="d-flex flex-wrap align-items-center gap-2">
                <select 
                    wire:model.live="selectedSeason" 
                    class="form-select form-select-sm"
                    style="min-width: 140px;"
                    wire:loading.attr="disabled"
                >
                    @foreach($seasons as $season)
                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                    @endforeach
                </select>
                
                <select 
                    wire:model.live="selectedOrderType" 
                    class="form-select form-select-sm"
                    style="min-width: 120px;"
                    wire:loading.attr="disabled"
                >
                    @foreach($orderTypes as $value => $label)
                        <option value="{{ $value }}">{{ $label }}</option>
                    @endforeach
                </select>
                
                <button 
                    wire:click="refreshData" 
                    class="btn btn-outline-light btn-sm"
                    wire:loading.attr="disabled"
                    title="Refresh Data"
                >
                    <i class="fas fa-sync-alt" wire:loading.class="fa-spin"></i>
                    <span class="d-none d-sm-inline ms-1">Refresh</span>
                </button>
            </div>
        </div>
    </div>

    @if($isLoading)
        <!-- Loading State -->
        <div class="card-body">
            <div class="d-flex justify-content-center align-items-center" style="min-height: 400px;">
                <div class="text-center">
                    <div class="spinner-border text-primary mb-3" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="text-muted">Loading sales data...</p>
                </div>
            </div>
        </div>
    @elseif(empty($salesData))
        <!-- Empty State -->
        <div class="card-body d-flex align-items-center justify-content-center" style="min-height: 400px;">
            <div class="text-center text-muted">
                <i class="fas fa-chart-bar fa-3x mb-3"></i>
                <h6 class="text-muted">No sales data</h6>
                <p class="text-muted small">No orders found for the selected season and order type.</p>
            </div>
        </div>
    @else
        <!-- Summary Cards -->
        <div class="card-body bg-light border-bottom">
            <div class="row g-3 text-center">
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-success mb-2">
                            <i class="fas fa-check-circle fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Shipped</div>
                        <div class="fw-bold text-success fs-5">£{{ number_format($totalSales, 0) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-warning mb-2">
                            <i class="fas fa-clock fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Remaining</div>
                        <div class="fw-bold text-warning fs-5">£{{ number_format(array_sum(array_column($salesData, 'remaining_sales')), 0) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-info mb-2">
                            <i class="fas fa-users fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Customers</div>
                        <div class="fw-bold text-info fs-5">{{ count($salesData) }}</div>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="d-flex flex-column align-items-center">
                        <div class="text-primary mb-2">
                            <i class="fas fa-percentage fs-4"></i>
                        </div>
                        <div class="small text-muted mb-1">Avg Progress</div>
                        <div class="fw-bold text-primary fs-5">
                            {{ number_format(array_sum(array_column($salesData, 'shipping_percentage')) / count($salesData), 0) }}%
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customer Data Table -->
        <div class="card-body p-0">
            <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                <table class="table table-hover mb-0">
                    <thead class="sticky-top bg-white border-bottom">
                        <tr>
                            <th class="border-0 py-3 px-4 fw-semibold text-muted">Customer</th>
                            <th class="border-0 py-3 px-4 fw-semibold text-muted text-end">Shipped</th>
                            <th class="border-0 py-3 px-4 fw-semibold text-muted text-end">Remaining</th>
                            <th class="border-0 py-3 px-4 fw-semibold text-muted text-center">Progress</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($salesData as $customerId => $data)
                            @php
                                $shippingPercentage = $data['shipping_percentage'] ?? 0;
                            @endphp
                            <tr class="border-bottom">
                                <td class="py-3 px-4">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" 
                                             style="width: 32px; height: 32px; font-size: 12px; font-weight: 600;">
                                            {{ substr($data['name'], 0, 1) }}
                                        </div>
                                        <div>
                                            <div class="fw-semibold">{{ Str::limit($data['name'], 30) }}</div>
                                            <div class="badge bg-light text-dark" style="font-size: 0.75rem;">{{ $data['department'] }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-3 px-4 text-end">
                                    <div class="fw-bold text-success fs-6">£{{ number_format($data['shipped_sales'] ?? 0, 0) }}</div>
                                </td>
                                <td class="py-3 px-4 text-end">
                                    <div class="fw-bold text-warning fs-6">£{{ number_format($data['remaining_sales'] ?? 0, 0) }}</div>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <div class="fw-semibold text-muted mb-2">{{ number_format($shippingPercentage, 0) }}%</div>
                                    <div class="progress mb-2" style="height: 6px;">
                                        <div class="progress-bar bg-success" 
                                             role="progressbar" 
                                             style="width: {{ $shippingPercentage }}%">
                                        </div>
                                    </div>
                                    <div class="small text-muted">{{ number_format($data['shipped_drops'] ?? 0) }}/{{ number_format($data['total_drops'] ?? 0) }} drops</div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>