<?php

namespace Database\Factories;

use App\Models\Profile;
use Illuminate\Database\Eloquent\Factories\Factory;

/** @extends Factory<Profile> */
class ProfileFactory extends Factory
{
    protected $model = Profile::class;

    public function definition(): array
    {
        return [
            'display_name' => $this->faker->name(),
            'goals' => ['sleep', 'relaxation'],
            'voice_prefs' => ['voice' => 'female_british_soft'],
            'sensitivity' => 'none',
        ];
    }
}


