<?php

namespace App\Services;

use App\Contracts\ProfileService as ProfileServiceContract;
use App\Models\Profile;
use App\Models\User;

class ProfileServiceImpl implements ProfileServiceContract
{
    public function updateProfile(User $user, array $attributes): Profile
    {
        $payload = [];
        foreach (['display_name', 'preferences', 'sensitivity'] as $key) {
            if (array_key_exists($key, $attributes)) {
                $payload[$key] = $attributes[$key];
            }
        }

        $profile = Profile::query()->updateOrCreate(
            ['user_id' => $user->id],
            $payload
        );

        return $profile->refresh();
    }
}


