<div class="space-y-6">
    <div>
        <h1 class="text-2xl font-bold">{{ $track->title }}</h1>
        <div class="text-gray-600">{{ ucfirst($track->level) }} • {{ $track->duration_sec }} sec</div>
        @if ($track->voiceActor)
            <div class="text-sm text-gray-500">Voice: {{ $track->voiceActor->name }}</div>
        @endif
        <div class="mt-3">{{ $track->description }}</div>
        <div class="mt-2 flex gap-2 flex-wrap">
            @foreach ($track->tags as $tag)
                <span class="badge badge-outline">{{ $tag->name }}</span>
            @endforeach
        </div>
    </div>
    @if ($audioUrl)
        <audio controls src="{{ $audioUrl }}" class="w-full"></audio>
    @endif
    <div class="flex gap-3">
        <button class="btn btn-primary" wire:click="play">Play</button>
        <button class="btn" wire:click="complete">Complete</button>
    </div>
</div>


