<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::orderBy('sort_order')->get();
        return view('admin.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:150',
            'slug' => 'nullable|string|max:160|unique:categories,slug',
            'description' => 'nullable|string',
            'sort_order' => 'nullable|integer|min:0',
        ]);
        if (empty($data['slug'])) {
            $data['slug'] = Str::slug($data['name']);
        }
        $data['sort_order'] = $data['sort_order'] ?? 0;
        Category::create($data);
        return redirect()->route('admin.categories.index')->with('status', 'Category created');
    }

    public function edit(Category $category)
    {
        return view('admin.categories.edit', compact('category'));
    }

    public function update(Request $request, Category $category)
    {
        $data = $request->validate([
            'name' => 'required|string|max:150',
            'slug' => 'nullable|string|max:160|unique:categories,slug,'.$category->id,
            'description' => 'nullable|string',
            'sort_order' => 'nullable|integer|min:0',
        ]);
        if (empty($data['slug'])) {
            $data['slug'] = Str::slug($data['name']);
        }
        $data['sort_order'] = $data['sort_order'] ?? 0;
        $category->update($data);
        return redirect()->route('admin.categories.index')->with('status', 'Category updated');
    }
}


