<div class="space-y-6">
    <h2 class="text-xl font-semibold">Favorites</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach ($favorites as $fav)
            <div class="rounded border p-4">
                <div class="font-semibold">{{ $fav->track->title }}</div>
                <div class="text-sm text-gray-600">{{ $fav->track->description }}</div>
                <div class="mt-3 flex justify-between items-center">
                    <a class="link link-primary" href="{{ route('tracks.show', ['track' => $fav->track_id]) }}">Open</a>
                    <button class="btn btn-sm" wire:click="toggleFavorite('{{ $fav->track_id }}')">Toggle favorite</button>
                </div>
            </div>
        @endforeach
    </div>
    {{ $favorites->links() }}
</div>


