
<nav id="sidebar" class="navbar navbar-expand-md p-0"> <!-- sticky-top -->
    <div class="d-flex flex-column flex-shrink-0 w-100 bg-primary" style="height: 100vh;">
        <div class="px-3">
            <a href="/" class="">
                <span class=""><img class="mx-auto d-block" src="/logo-white.png" style="max-width: 150px"></span>
            </a>
            <hr class="text-white">
        </div>
        <ul class="nav nav-pills flex-column mb-auto">
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->segment(1) == '' ? 'bg-primary' : '' }}" href="{{ route('dashboard') }}" class="nav-link">
                    <span class="fw-semibold">
                        <i class="fas fa-tachometer-alt text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Dashboard</span>
                    </span>
                </a>
            </li>
            <!-- <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->segment(1) == 'dashboardbeta' ? 'bg-primary' : '' }}" href="{{ route('dashboardbeta') }}" class="nav-link">
                    <span class="fw-semibold">
                        <i class="fas fa-chart-line text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Dashboard Beta</span>
                    </span>
                </a>
            </li> -->


            <livewire:navigation.navigation-dropdown    dropdownName="Development"
                                                        img="dev.png"
                                                        :subs="[
                                                            'Designs' => 'designs',
                                                            'Styles' => 'styles',
                                                            'Samples' => 'samples',
                                                            'Bulk Samples' => 'samplesbulk',
                                                            'Styles Overview' => 'stylesoverview'
                                                        ]"
                                                        wire:key="Development" />

            <livewire:navigation.navigation-dropdown    dropdownName="Sales"
                                                        img="sales.png"
                                                        :subs="[
                                                            'Orders' => 'orders',
                                                        ]"
                                                        :tertiary="[
                                                            'Pricing' => [
                                                                'KWT' => 'pricing',
                                                                'KWA' => 'kwapricing'
                                                            ],
                                                            'Sales Values' => [
                                                                'Wholesale' => 'salesvalues',
                                                                'Commission' => 'commissionsalesvalues'
                                                            ],
                                                        ]"
                                                        wire:key="Sales" />

            <livewire:navigation.navigation-dropdown    dropdownName="Production"
                                                        img="production.png"
                                                        :subs="[
                                                            'Shipments' => 'shipments',
                                                            'Factory PO' => 'factorypo',
                                                            'Yarn PO' => 'yarnpo'
                                                        ]"
                                                        :tertiary="[
                                                            'Critical Paths' => [
                                                                'Wholesale' => 'criticalpath',
                                                                'Asos' => 'asoscriticalpath'
                                                            ],
                                                            'Shipment Schedules' => [
                                                                'Wholesale' => 'shipmentschedule',
                                                                'Commission' => 'commissionshipmentschedule'
                                                            ]
                                                        ]"
                                                        wire:key="Production" />

            <livewire:navigation.navigation-dropdown    dropdownName="Finance"
                                                        img="finance.png"
                                                        :subs="[
                                                            'Samples' => 'samplesinvoice',
                                                            'Samples (New)' => 'samplesinvoicenew',
                                                            'WH Cashflow' => 'cashflow'
                                                        ]"
                                                        wire:key="Finance" />

            <livewire:navigation.navigation-dropdown    dropdownName="Tools"
                                                        img="production.png"
                                                        :subs="[
                                                            'Drop Lookup' => 'prodlookup',
                                                            'Customers' => 'customers',
                                                            'Suppliers' => 'suppliers',
                                                        ]"
                                                        :tertiary="['Attributes' => [
                                                            'Departments' => 'departments',
                                                            'Seasons' => 'seasons',
                                                            'Yarns' => 'yarns',
                                                            'Materials' => 'materials',
                                                            'Counts' => 'counts',
                                                            'Sample Types' => 'sampletypes',
                                                            'Sizes' => 'sizes',
                                                            'Gauges' => 'gauges',
                                                            'Invoice Layouts' => 'invoicelayouts',
                                                        ],
                                                        'Logs' => [
                                                            'Style Logs' => 'viewstylelogs',
                                                            'Order Logs' => 'vieworderlogs',
                                                            'Logs' => 'viewlogs',
                                                        ]]"
                                                        wire:key="Tools" />

            <livewire:navigation.navigation-dropdown    dropdownName="Import"
                                                        img="import.png"
                                                        :subs="[

                                                        ]"
                                                        :tertiary="[
                                                            'Orders' => [
                                                                'KWT' => 'importordersupload',
                                                                'KWA' => 'importaiorderskwa',
                                                                'ASOS' => 'importaiordersasos',
                                                            ],
                                                            'Packing Lists' => [
                                                                'ASOS' => 'importpackinglistasos',
                                                                'ASOS Ananta PO' => 'importasosanantapo',
                                                            ],
                                                            'Pricing' => [
                                                                'Import Prices' => 'importprices',
                                                            ]
                                                        ]"
                                                        wire:key="Import" />
            @can('admin-only')
            <livewire:navigation.navigation-dropdown    dropdownName="Management"
                                                        img="import.png"
                                                        :subs="[
                                                            'Users' => 'users',
                                                        ]"
                                                        wire:key="Import" />
            @endcan

        </ul>
        <hr>
        <div class="px-3 pb-3">
            <button class="btn btn-outline-light w-100" onclick="toggleTheme()">
                <i class="fas fa-adjust"></i> Toggle Theme
            </button>
            <script>
                (function() {
                    try {
                        var stored = localStorage.getItem('theme');
                        if (!stored && window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) stored = 'dark';
                        applyTheme(stored || 'light');
                    } catch (e) {}
                })();
                function applyTheme(theme){
                    if(theme === 'dark'){
                        document.documentElement.setAttribute('data-bs-theme','dark');
                    } else {
                        document.documentElement.setAttribute('data-bs-theme','light');
                    }
                    try { localStorage.setItem('theme', theme); } catch(e) {}
                }
                function toggleTheme(){
                    var current = document.documentElement.getAttribute('data-bs-theme') || 'light';
                    applyTheme(current === 'dark' ? 'light' : 'dark');
                }
            </script>
        </div>
      </div>
</nav>
