@extends('layouts.frontend')

@section('meta_title', 'Yarn Store - Premium Quality Yarns by Robert Todd Yarn')
@section('meta_description', 'Discover our curated collection of premium yarns. Shop by season and category to find the perfect yarn for your next project.')
@section('meta_keywords', 'yarn store, premium yarn, knitting yarn, wool, cotton, seasonal collections, Robert Todd Yarn')

@section('content')
<!-- Hero Section -->
<section class="hero-section">
    <div class="container hero-content">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <h1 class="display-3 fw-bold mb-4">
                    Discover Premium Yarns
                </h1>
                <p class="lead mb-4">
                    Curated collections of the finest yarns for your creative projects. 
                    From timeless classics to contemporary designs, find your perfect match.
                </p>
                <div class="d-flex gap-3 flex-wrap">
                    <a href="{{ route('collections') }}" class="btn btn-ys-primary btn-lg">
                        Browse Collections
                    </a>
                    <a href="{{ route('about') }}" class="btn btn-ys-secondary btn-lg">
                        Learn More
                    </a>
                </div>
            </div>
            <div class="col-lg-5 d-none d-lg-block text-end">
                <div class="p-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="300" height="300" fill="white" opacity="0.2" viewBox="0 0 16 16">
                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                        <path d="M3.5 7.5a.5.5 0 0 1 .5.5c0 1.93 1.57 3.5 3.5 3.5S11 9.93 11 8a.5.5 0 0 1 1 0 4.5 4.5 0 1 1-9 0 .5.5 0 0 1 .5-.5z"/>
                        <path d="M7.5 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 .5-.5z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Seasons -->
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="h1 fw-bold mb-3">Shop by Season</h2>
            <p class="text-muted">Explore our carefully curated seasonal collections</p>
        </div>

        <div class="row g-4">
            @forelse($seasons as $season)
                <div class="col-lg-4 col-md-6">
                    <a href="{{ route('collections.season', $season->slug) }}" class="text-decoration-none">
                        <div class="ys-card h-100 overflow-hidden">
                            @if($season->image)
                                <img src="{{ Storage::url($season->image) }}" 
                                     alt="{{ $season->name }}" 
                                     class="product-image"
                                     loading="lazy">
                            @else
                                <div class="product-image d-flex align-items-center justify-content-center" 
                                     style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%);">
                                    <h3 class="text-white">{{ $season->name }}</h3>
                                </div>
                            @endif
                            <div class="p-4">
                                <h3 class="h4 fw-bold mb-2">{{ $season->name }}</h3>
                                <p class="text-muted mb-3">{{ Str::limit($season->description, 100) }}</p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted small">{{ $season->items()->where('is_active', true)->count() }} items</span>
                                    <span class="text-primary fw-semibold">
                                        Explore →
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        New seasonal collections coming soon!
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="py-5" style="background-color: var(--ys-bg-tertiary);">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="h1 fw-bold mb-3">Featured Products</h2>
            <p class="text-muted">Hand-picked favorites from our collection</p>
        </div>

        <div class="product-grid">
            @forelse($featuredProducts as $product)
                <a href="{{ route('product', $product->slug) }}" class="text-decoration-none">
                    <div class="product-card">
                        @if($product->primary_image)
                            <img src="{{ Storage::url($product->primary_image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="product-image"
                                 loading="lazy">
                        @else
                            <div class="product-image d-flex align-items-center justify-content-center" 
                                 style="background-color: var(--ys-bg-tertiary);">
                                <span class="text-muted">No image</span>
                            </div>
                        @endif
                        <div class="product-info">
                            <h3 class="h6 fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h3>
                            <p class="text-muted small mb-2">
                                {{ $product->season->name }} • {{ $product->category->name }}
                            </p>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                @if($product->colourways->count() > 0)
                                    <span class="text-muted small">
                                        {{ $product->colourways->count() }} {{ Str::plural('colour', $product->colourways->count()) }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </a>
            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        New products coming soon!
                    </div>
                </div>
            @endforelse
        </div>

        <div class="text-center mt-5">
            <a href="{{ route('collections') }}" class="btn btn-ys-primary btn-lg">
                View All Products
            </a>
        </div>
    </div>
</section>

<!-- Categories -->
<section class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="h1 fw-bold mb-3">Shop by Category</h2>
            <p class="text-muted">Find exactly what you're looking for</p>
        </div>

        <div class="row g-4">
            @forelse($categories as $category)
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <a href="{{ route('category', $category->slug) }}" class="text-decoration-none">
                        <div class="ys-card text-center p-4">
                            <div class="mb-3">
                                <div class="rounded-circle d-inline-flex align-items-center justify-content-center" 
                                     style="width: 80px; height: 80px; background-color: var(--ys-primary); opacity: 0.1;">
                                </div>
                            </div>
                            <h3 class="h5 fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $category->name }}
                            </h3>
                            <p class="text-muted small mb-0">
                                {{ $category->items()->where('is_active', true)->count() }} items
                            </p>
                        </div>
                    </a>
                </div>
            @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        Categories coming soon!
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-5" style="background-color: var(--ys-bg-secondary);">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="h1 fw-bold mb-3">Why Choose Yarn Store?</h2>
        </div>

        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="text-center p-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                            <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
                        </svg>
                    </div>
                    <h3 class="h5 fw-bold mb-2">Premium Quality</h3>
                    <p class="text-muted small">
                        Carefully selected yarns from the finest producers
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="text-center p-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                            <path d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"/>
                        </svg>
                    </div>
                    <h3 class="h5 fw-bold mb-2">Fast Delivery</h3>
                    <p class="text-muted small">
                        Quick and secure shipping throughout the UK
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="text-center p-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                            <path d="M1 2.5A1.5 1.5 0 0 1 2.5 1h3A1.5 1.5 0 0 1 7 2.5v3A1.5 1.5 0 0 1 5.5 7h-3A1.5 1.5 0 0 1 1 5.5v-3zM2.5 2a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 1h3A1.5 1.5 0 0 1 15 2.5v3A1.5 1.5 0 0 1 13.5 7h-3A1.5 1.5 0 0 1 9 5.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zM1 10.5A1.5 1.5 0 0 1 2.5 9h3A1.5 1.5 0 0 1 7 10.5v3A1.5 1.5 0 0 1 5.5 15h-3A1.5 1.5 0 0 1 1 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 9h3a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3z"/>
                        </svg>
                    </div>
                    <h3 class="h5 fw-bold mb-2">Wide Selection</h3>
                    <p class="text-muted small">
                        Extensive range across all seasons and categories
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="text-center p-4">
                    <div class="mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                            <path d="M2.678 11.894a1 1 0 0 1 .287.801 10.97 10.97 0 0 1-.398 2c1.395-.323 2.247-.697 2.634-.893a1 1 0 0 1 .71-.074A8.06 8.06 0 0 0 8 14c3.996 0 7-2.807 7-6 0-3.192-3.004-6-7-6S1 4.808 1 8c0 1.468.617 2.83 1.678 3.894zm-.493 3.905a21.682 21.682 0 0 1-.713.129c-.2.032-.352-.176-.273-.362a9.68 9.68 0 0 0 .244-.637l.003-.01c.248-.72.45-1.548.524-2.319C.743 11.37 0 9.76 0 8c0-3.866 3.582-7 8-7s8 3.134 8 7-3.582 7-8 7a9.06 9.06 0 0 1-2.347-.306c-.52.263-1.639.742-3.468 1.105z"/>
                        </svg>
                    </div>
                    <h3 class="h5 fw-bold mb-2">Expert Support</h3>
                    <p class="text-muted small">
                        Knowledgeable team ready to help with your projects
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Signup -->
<section class="py-5" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-dark) 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 text-white mb-4 mb-lg-0">
                <h2 class="h2 fw-bold mb-3">Stay Updated</h2>
                <p class="mb-0">
                    Subscribe to our newsletter for new arrivals, exclusive offers, and knitting inspiration.
                </p>
            </div>
            <div class="col-lg-6">
                <form class="d-flex gap-2">
                    <input type="email" 
                           class="form-control form-control-lg" 
                           placeholder="Enter your email"
                           required>
                    <button type="submit" class="btn btn-light btn-lg text-nowrap fw-semibold">
                        Subscribe
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection

