<?php

namespace App\Livewire\Library;

use App\Contracts\LibraryService;
use App\Models\Tag;
use Illuminate\Support\Arr;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;

class BrowseTracks extends Component
{
    use WithPagination;

    #[Url]
    public string $search = '';

    #[Url(as: 'tags')]
    public array $selectedTagIds = [];

    #[Url]
    public ?string $level = null;

    public int $perPage = 24;

    public function updatingSearch(): void
    {
        $this->resetPage();
    }

    public function updatingSelectedTagIds(): void
    {
        $this->resetPage();
    }

    public function updatingLevel(): void
    {
        $this->resetPage();
    }

    public function render(LibraryService $library)
    {
        $tagIds = array_map('intval', $this->selectedTagIds);
        $tagSlugs = empty($tagIds) ? null : Tag::whereIn('id', $tagIds)->pluck('slug')->all();

        $tracks = $library->listTracks($tagSlugs, $this->level ?: null, $this->perPage, $this->search ?: null);

        $allTags = Tag::orderBy('slug')->get(['id', 'name', 'slug']);

        return view('livewire.library.browse-tracks', [
            'tracks' => $tracks,
            'allTags' => $allTags,
        ]);
    }
}


