<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Category;
use App\Models\Item;
use App\Models\Season;

class ShopCategory extends Component
{
    use WithPagination;

    public $categorySlug;
    public $category;
    public $selectedSeason = null;
    public $sortBy = 'latest';

    protected $queryString = ['selectedSeason', 'sortBy'];

    public function mount($categorySlug)
    {
        $this->categorySlug = $categorySlug;
        $this->category = Category::where('slug', $categorySlug)
            ->firstOrFail();
    }

    public function updatedSelectedSeason()
    {
        $this->resetPage();
    }

    public function updatedSortBy()
    {
        $this->resetPage();
    }

    public function render()
    {
        $query = Item::where('categories_id', $this->category->id)
            ->with(['season', 'category']);

        if ($this->selectedSeason) {
            $query->whereHas('season', function($q) {
                $q->where('slug', $this->selectedSeason);
            });
        }

        switch ($this->sortBy) {
            case 'price_asc':
                $query->orderBy('price', 'asc');
                break;
            case 'price_desc':
                $query->orderBy('price', 'desc');
                break;
            case 'name':
                $query->orderBy('name', 'asc');
                break;
            default:
                $query->latest();
        }

        $products = $query->paginate(12);

        $seasons = Season::whereHas('items', function($q) {
                $q->where('categories_id', $this->category->id);
            })
            ->orderBy('sort_order')
            ->get();

        return view('livewire.shop-category', [
            'products' => $products,
            'seasons' => $seasons,
        ])->layout('layouts.shop');
    }
}

