<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Cookie;

class CookieConsent extends Component
{
    public $show = false;

    public function mount()
    {
        $this->show = !Cookie::has('cookie_consent');
    }

    public function acceptAll()
    {
        Cookie::queue('cookie_consent', 'all', 60 * 24 * 365); // 1 year
        Cookie::queue('analytics_enabled', 'true', 60 * 24 * 365);
        $this->show = false;
    }

    public function acceptNecessary()
    {
        Cookie::queue('cookie_consent', 'necessary', 60 * 24 * 365); // 1 year
        Cookie::queue('analytics_enabled', 'false', 60 * 24 * 365);
        $this->show = false;
    }

    public function render()
    {
        return view('livewire.cookie-consent');
    }
}
