<?php

namespace App\Livewire;

use Livewire\Component;

class CookieConsent extends Component
{
    public $showBanner = false;

    public function mount()
    {
        $this->showBanner = !request()->cookie('cookie_consent');
    }

    public function acceptAll()
    {
        cookie()->queue('cookie_consent', 'all', 60 * 24 * 365);
        cookie()->queue('cookie_analytics', 'true', 60 * 24 * 365);
        $this->showBanner = false;
        
        $this->dispatch('cookies-accepted');
    }

    public function acceptEssential()
    {
        cookie()->queue('cookie_consent', 'essential', 60 * 24 * 365);
        cookie()->queue('cookie_analytics', 'false', 60 * 24 * 365);
        $this->showBanner = false;
    }

    public function render()
    {
        return view('livewire.cookie-consent');
    }
}
