<?php
// Vertical sidebar navigation menu
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_dir = basename(dirname($_SERVER['PHP_SELF']));
?>

<nav class="sidebar bg-white shadow-sm border-end" style="width: 280px; min-height: 100vh; position: fixed; top: 0; left: 0; z-index: 1000;">
  <div class="p-4">
    <!-- Logo -->
    <div class="mb-4">
      <a href="/" class="text-decoration-none">
        <h4 class="fw-bold text-primary mb-0">Neil Widdowson IT & Web</h4>
      </a>
    </div>

    <!-- Navigation Menu -->
    <ul class="nav flex-column">
      
      <!-- Services Section -->
      <li class="nav-item mb-2">
        <h6 class="fw-bold text-dark mb-2">Services</h6>
        <ul class="nav flex-column ms-3">
          <li class="nav-item mb-1">
            <h6 class="text-muted mb-1">Website Services</h6>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/services/website-design.php">
              <div class="fw-medium">Website Design</div>
              <small class="text-muted">Custom websites that win work</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/services/software-dev.php">
              <div class="fw-medium">Software Development</div>
              <small class="text-muted">Custom applications & solutions</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/services/seo.php">
              <div class="fw-medium">SEO & Marketing</div>
              <small class="text-muted">Get found online</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/services/website-care.php">
              <div class="fw-medium">Website Care</div>
              <small class="text-muted">Ongoing maintenance & support</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/services/it-support.php">
              <div class="fw-medium">IT Support</div>
              <small class="text-muted">Friendly local technical support</small>
            </a>
          </li>
        </ul>
      </li>

      <!-- Portfolio -->
      <li class="nav-item mb-2">
        <a class="nav-link text-dark fw-medium" href="/portfolio/">Portfolio</a>
      </li>

      <!-- About -->
      <li class="nav-item mb-2">
        <a class="nav-link text-dark fw-medium" href="/about/">About</a>
      </li>

      <!-- Resources Section -->
      <li class="nav-item mb-2">
        <h6 class="fw-bold text-dark mb-2">Resources</h6>
        <ul class="nav flex-column ms-3">
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/pricing/">
              <div class="fw-medium">Pricing</div>
              <small class="text-muted">Transparent pricing for all services</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/faqs/">
              <div class="fw-medium">FAQs</div>
              <small class="text-muted">Common questions answered</small>
            </a>
          </li>
          <li class="nav-item mb-2">
            <a class="nav-link text-dark p-0" href="/bitdefender/">
              <div class="fw-medium">Bitdefender</div>
              <small class="text-muted">Security solutions</small>
            </a>
          </li>
        </ul>
      </li>

      <!-- Contact -->
      <li class="nav-item mb-4">
        <a class="nav-link text-dark fw-medium" href="/contact/">Contact</a>
      </li>
    </ul>

    <!-- CTA Button -->
    <div class="mt-auto">
      <a href="/contact/" class="btn btn-primary w-100 rounded-pill">
        Get Started
      </a>
    </div>
  </div>
</nav>

<!-- Main content wrapper to account for sidebar -->
<div style="margin-left: 280px; min-height: 100vh;">