<?php
// Reusable navigation component
// Expects $currentPage variable to be set for highlighting active page
$currentPage = $currentPage ?? '';
?>

<header class="sticky top-0 z-40 bg-white/90 backdrop-blur supports-[backdrop-filter]:bg-white/60 border-b border-gray-100">
  <div class="container flex items-center justify-between h-16">
    <a href="/" class="flex items-center gap-3" aria-label="Neil Widdowson IT & Web home">
      <div class="h-9 w-9 rounded-2xl bg-accent-600 text-white grid place-items-center font-bold">NW</div>
      <div class="text-gray-900 font-semibold leading-tight">
        <span class="block">Neil Widdowson</span>
        <span class="block text-xs text-gray-500">IT & Website Services</span>
      </div>
    </a>

    <nav class="hidden md:flex items-center gap-6" aria-label="Primary">
      <div class="relative">
        <button id="services-dropdown" class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded flex items-center gap-1" aria-expanded="false" aria-haspopup="true">
          Services
          <svg id="services-arrow" class="h-4 w-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
          </svg>
        </button>
        <div id="services-menu" class="absolute top-full left-0 w-64 bg-white rounded-lg shadow-lg border border-gray-100 opacity-0 invisible transition-all duration-200 z-50 max-h-96 overflow-y-auto hidden" style="transform: translateY(4px);">
          <div class="py-2">
            <a href="/services/website-design.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
              <div class="font-medium">Website Design</div>
              <div class="text-xs text-gray-500 mt-1">Fast, mobile-first Joomla sites</div>
            </a>
            <a href="/services/it-support.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
              <div class="font-medium">IT Support</div>
              <div class="text-xs text-gray-500 mt-1">Friendly local help & security</div>
            </a>
            <a href="/services/website-care.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
              <div class="font-medium">Website Care</div>
              <div class="text-xs text-gray-500 mt-1">Updates, backups & hosting</div>
            </a>
            <a href="/services/software-dev.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-gray-900">
              <div class="font-medium">Software Development</div>
              <div class="text-xs text-gray-500 mt-1">Custom apps & AI integrations</div>
            </a>
          </div>
        </div>
      </div>
      <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded <?php echo $currentPage === 'portfolio' ? 'text-accent-600 font-medium' : ''; ?>" href="/portfolio/">Portfolio</a>
      <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded <?php echo $currentPage === 'pricing' ? 'text-accent-600 font-medium' : ''; ?>" href="/pricing/">Pricing</a>
      <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded <?php echo $currentPage === 'faqs' ? 'text-accent-600 font-medium' : ''; ?>" href="/faqs/">FAQs</a>
      <a class="text-sm text-gray-700 hover:text-gray-900 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 rounded <?php echo $currentPage === 'about' ? 'text-accent-600 font-medium' : ''; ?>" href="/about/">About</a>
    </nav>

    <div class="hidden md:block">
      <a class="btn-primary" href="/contact/">Get a free quote</a>
    </div>

    <button id="nav-toggle" class="md:hidden inline-flex items-center justify-center h-10 w-10 rounded-xl focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" aria-controls="mobile-nav" aria-expanded="false" aria-label="Open menu">
      <svg class="h-6 w-6 text-gray-900" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><line x1="3" y1="6" x2="21" y2="6"></line><line x1="3" y1="12" x2="21" y2="12"></line><line x1="3" y1="18" x2="21" y2="18"></line></svg>
    </button>
  </div>

  <div id="mobile-nav" class="md:hidden hidden border-t border-gray-100" aria-label="Mobile" role="dialog">
    <div class="container py-3">
      <div class="flex flex-col gap-2">
        <div class="px-2 py-2">
          <div class="text-sm font-medium text-gray-900 mb-2">Services</div>
          <div class="ml-4 space-y-1">
            <a class="block px-2 py-1 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded" href="/services/website-design.php">Website Design</a>
            <a class="block px-2 py-1 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded" href="/services/it-support.php">IT Support</a>
            <a class="block px-2 py-1 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded" href="/services/website-care.php">Website Care</a>
            <a class="block px-2 py-1 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded" href="/services/software-dev.php">Software Development</a>
          </div>
        </div>
        <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 <?php echo $currentPage === 'portfolio' ? 'bg-accent-50 text-accent-700' : ''; ?>" href="/portfolio/">Portfolio</a>
        <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 <?php echo $currentPage === 'pricing' ? 'bg-accent-50 text-accent-700' : ''; ?>" href="/pricing/">Pricing</a>
        <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 <?php echo $currentPage === 'faqs' ? 'bg-accent-50 text-accent-700' : ''; ?>" href="/faqs/">FAQs</a>
        <a class="px-2 py-2 rounded-xl hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500 <?php echo $currentPage === 'about' ? 'bg-accent-50 text-accent-700' : ''; ?>" href="/about/">About</a>
        <a class="btn-primary mt-2" href="/contact/">Get a free quote</a>
      </div>
    </div>
  </div>
</header>
