<?php
// Navigation menu similar to Webflow's structure
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_dir = basename(dirname($_SERVER['PHP_SELF']));
?>

<nav class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-50">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center h-16">
      <!-- Logo -->
      <div class="flex-shrink-0">
        <a href="/" class="flex items-center">
          <span class="text-xl font-bold text-blue-600">Neil Widdowson</span>
          <span class="ml-2 text-sm text-gray-600 hidden sm:block">IT & Web</span>
        </a>
      </div>

      <!-- Desktop Navigation -->
      <div class="hidden lg:block">
        <div class="ml-10 flex items-baseline space-x-8">
          
          <!-- Services Dropdown -->
          <div class="relative group">
            <button class="text-gray-700 hover:text-blue-600 px-3 py-2 text-sm font-medium transition-colors duration-200 flex items-center">
              Services
              <svg class="ml-1 h-4 w-4 transition-transform duration-200 group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
              </svg>
            </button>
            
            <!-- Services Dropdown Menu -->
            <div class="absolute left-0 mt-2 w-80 bg-white rounded-lg shadow-lg border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform translate-y-2 group-hover:translate-y-0">
              <div class="py-2">
                <div class="px-4 py-2 border-b border-gray-100">
                  <h3 class="text-sm font-semibold text-gray-900">Website Services</h3>
                </div>
                <a href="/services/website-design.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">Website Design</div>
                  <div class="text-xs text-gray-500 mt-1">Custom websites that win work</div>
                </a>
                <a href="/services/software-dev.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">Software Development</div>
                  <div class="text-xs text-gray-500 mt-1">Custom applications & solutions</div>
                </a>
                <a href="/services/seo.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">SEO & Marketing</div>
                  <div class="text-xs text-gray-500 mt-1">Get found online</div>
                </a>
                <a href="/services/website-care.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">Website Care</div>
                  <div class="text-xs text-gray-500 mt-1">Ongoing maintenance & support</div>
                </a>
                
                <div class="px-4 py-2 border-t border-gray-100 mt-2">
                  <h3 class="text-sm font-semibold text-gray-900">IT Support</h3>
                </div>
                <a href="/services/it-support.php" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">IT Support</div>
                  <div class="text-xs text-gray-500 mt-1">Friendly local technical support</div>
                </a>
              </div>
            </div>
          </div>

          <!-- Portfolio -->
          <a href="/portfolio/" class="text-gray-700 hover:text-blue-600 px-3 py-2 text-sm font-medium transition-colors duration-200">
            Portfolio
          </a>

          <!-- About -->
          <a href="/about/" class="text-gray-700 hover:text-blue-600 px-3 py-2 text-sm font-medium transition-colors duration-200">
            About
          </a>

          <!-- Resources Dropdown -->
          <div class="relative group">
            <button class="text-gray-700 hover:text-blue-600 px-3 py-2 text-sm font-medium transition-colors duration-200 flex items-center">
              Resources
              <svg class="ml-1 h-4 w-4 transition-transform duration-200 group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
              </svg>
            </button>
            
            <!-- Resources Dropdown Menu -->
            <div class="absolute left-0 mt-2 w-64 bg-white rounded-lg shadow-lg border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform translate-y-2 group-hover:translate-y-0">
              <div class="py-2">
                <a href="/pricing/" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">Pricing</div>
                  <div class="text-xs text-gray-500 mt-1">Transparent pricing for all services</div>
                </a>
                <a href="/faqs/" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">FAQs</div>
                  <div class="text-xs text-gray-500 mt-1">Common questions answered</div>
                </a>
                <a href="/bitdefender/" class="block px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 hover:text-blue-600 transition-colors">
                  <div class="font-medium">Bitdefender</div>
                  <div class="text-xs text-gray-500 mt-1">Security solutions</div>
                </a>
              </div>
            </div>
          </div>

          <!-- Contact -->
          <a href="/contact/" class="text-gray-700 hover:text-blue-600 px-3 py-2 text-sm font-medium transition-colors duration-200">
            Contact
          </a>
        </div>
      </div>

      <!-- CTA Button -->
      <div class="hidden lg:block">
        <a href="/contact/" class="bg-blue-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors duration-200">
          Get Started
        </a>
      </div>

      <!-- Mobile menu button -->
      <div class="lg:hidden">
        <button id="mobile-menu-button" class="text-gray-700 hover:text-blue-600 focus:outline-none focus:text-blue-600">
          <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path id="menu-icon" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
            <path id="close-icon" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
          </svg>
        </button>
      </div>
    </div>
  </div>

  <!-- Mobile Navigation Menu -->
  <div id="mobile-menu" class="lg:hidden hidden bg-white border-t border-gray-200">
    <div class="px-2 pt-2 pb-3 space-y-1">
      
      <!-- Services Mobile Section -->
      <div class="mobile-dropdown">
        <button class="mobile-dropdown-toggle w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md flex items-center justify-between">
          Services
          <svg class="h-4 w-4 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
          </svg>
        </button>
        <div class="mobile-dropdown-content hidden pl-4 space-y-1">
          <a href="/services/website-design.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Website Design</a>
          <a href="/services/software-dev.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Software Development</a>
          <a href="/services/seo.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">SEO & Marketing</a>
          <a href="/services/website-care.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Website Care</a>
          <a href="/services/it-support.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">IT Support</a>
        </div>
      </div>

      <!-- Portfolio -->
      <a href="/portfolio/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        Portfolio
      </a>

      <!-- About -->
      <a href="/about/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        About
      </a>

      <!-- Resources Mobile Section -->
      <div class="mobile-dropdown">
        <button class="mobile-dropdown-toggle w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md flex items-center justify-between">
          Resources
          <svg class="h-4 w-4 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
          </svg>
        </button>
        <div class="mobile-dropdown-content hidden pl-4 space-y-1">
          <a href="/pricing/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Pricing</a>
          <a href="/faqs/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">FAQs</a>
          <a href="/bitdefender/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Bitdefender</a>
        </div>
      </div>

      <!-- Contact -->
      <a href="/contact/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        Contact
      </a>

      <!-- Mobile CTA -->
      <div class="pt-4 pb-2">
        <a href="/contact/" class="block w-full bg-blue-600 text-white text-center px-4 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors duration-200">
          Get Started
        </a>
      </div>
    </div>
  </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const mobileMenuButton = document.getElementById('mobile-menu-button');
  const mobileMenu = document.getElementById('mobile-menu');
  const menuIcon = document.getElementById('menu-icon');
  const closeIcon = document.getElementById('close-icon');
  
  // Toggle mobile menu
  mobileMenuButton.addEventListener('click', function() {
    mobileMenu.classList.toggle('hidden');
    menuIcon.classList.toggle('hidden');
    closeIcon.classList.toggle('hidden');
  });

  // Mobile dropdown functionality
  const mobileDropdownToggles = document.querySelectorAll('.mobile-dropdown-toggle');
  
  mobileDropdownToggles.forEach(toggle => {
    toggle.addEventListener('click', function() {
      const content = this.nextElementSibling;
      const icon = this.querySelector('svg');
      
      content.classList.toggle('hidden');
      icon.classList.toggle('rotate-180');
    });
  });

  // Close mobile menu when clicking outside
  document.addEventListener('click', function(event) {
    if (!mobileMenuButton.contains(event.target) && !mobileMenu.contains(event.target)) {
      mobileMenu.classList.add('hidden');
      menuIcon.classList.remove('hidden');
      closeIcon.classList.add('hidden');
    }
  });
});
</script>
