<?php
// Navigation menu similar to Webflow's structure
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_dir = basename(dirname($_SERVER['PHP_SELF']));
?>

<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm border-bottom sticky-top" style="z-index: 1030;">
  <div class="container">
    <!-- Logo -->
    <a class="navbar-brand fw-bold text-primary" href="/">
      Neil Widdowson
      <small class="text-muted d-none d-sm-inline">IT & Web</small>
    </a>

    <!-- Mobile menu button -->
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Desktop Navigation -->
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        
        <!-- Services Dropdown -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="servicesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Services
          </a>
          <ul class="dropdown-menu dropdown-menu-lg-end" style="min-width: 350px;">
            <li><h6 class="dropdown-header">Website Services</h6></li>
            <li>
              <a class="dropdown-item" href="/services/website-design.php">
                <div class="fw-medium">Website Design</div>
                <small class="text-muted">Custom websites that win work</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/software-dev.php">
                <div class="fw-medium">Software Development</div>
                <small class="text-muted">Custom applications & solutions</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/seo.php">
                <div class="fw-medium">SEO & Marketing</div>
                <small class="text-muted">Get found online</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/website-care.php">
                <div class="fw-medium">Website Care</div>
                <small class="text-muted">Ongoing maintenance & support</small>
              </a>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li><h6 class="dropdown-header">IT Support</h6></li>
            <li>
              <a class="dropdown-item" href="/services/it-support.php">
                <div class="fw-medium">IT Support</div>
                <small class="text-muted">Friendly local technical support</small>
              </a>
            </li>
          </ul>
        </li>

        <!-- Portfolio -->
        <li class="nav-item">
          <a class="nav-link" href="/portfolio/">Portfolio</a>
        </li>

        <!-- About -->
        <li class="nav-item">
          <a class="nav-link" href="/about/">About</a>
        </li>

        <!-- Resources Dropdown -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="resourcesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Resources
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="/pricing/">
                <div class="fw-medium">Pricing</div>
                <small class="text-muted">Transparent pricing for all services</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/faqs/">
                <div class="fw-medium">FAQs</div>
                <small class="text-muted">Common questions answered</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/bitdefender/">
                <div class="fw-medium">Bitdefender</div>
                <small class="text-muted">Security solutions</small>
              </a>
            </li>
          </ul>
        </li>

        <!-- Contact -->
        <li class="nav-item">
          <a class="nav-link" href="/contact/">Contact</a>
        </li>
      </ul>

      <!-- CTA Button -->
      <div class="d-none d-lg-block">
        <a href="/contact/" class="btn btn-primary">
          Get Started
        </a>
      </div>
    </div>
  </div>

  <!-- Mobile Navigation Menu -->
  <div id="mobile-menu" class="lg:hidden hidden bg-white border-t border-gray-200">
    <div class="px-2 pt-2 pb-3 space-y-1">
      
      <!-- Services Mobile Section -->
      <div class="mobile-dropdown">
        <button class="mobile-dropdown-toggle w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md flex items-center justify-between">
          Services
          <svg class="h-4 w-4 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
          </svg>
        </button>
        <div class="mobile-dropdown-content hidden pl-4 space-y-1">
          <a href="/services/website-design.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Website Design</a>
          <a href="/services/software-dev.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Software Development</a>
          <a href="/services/seo.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">SEO & Marketing</a>
          <a href="/services/website-care.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Website Care</a>
          <a href="/services/it-support.php" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">IT Support</a>
        </div>
      </div>

      <!-- Portfolio -->
      <a href="/portfolio/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        Portfolio
      </a>

      <!-- About -->
      <a href="/about/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        About
      </a>

      <!-- Resources Mobile Section -->
      <div class="mobile-dropdown">
        <button class="mobile-dropdown-toggle w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md flex items-center justify-between">
          Resources
          <svg class="h-4 w-4 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
          </svg>
        </button>
        <div class="mobile-dropdown-content hidden pl-4 space-y-1">
          <a href="/pricing/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Pricing</a>
          <a href="/faqs/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">FAQs</a>
          <a href="/bitdefender/" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 hover:bg-gray-50 rounded-md">Bitdefender</a>
        </div>
      </div>

      <!-- Contact -->
      <a href="/contact/" class="block px-3 py-2 text-base font-medium text-gray-700 hover:text-blue-600 hover:bg-gray-50 rounded-md">
        Contact
      </a>

      <!-- Mobile CTA -->
      <div class="pt-4 pb-2">
        <a href="/contact/" class="block w-full bg-blue-600 text-white text-center px-4 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors duration-200">
          Get Started
        </a>
      </div>
    </div>
  </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const mobileMenuButton = document.getElementById('mobile-menu-button');
  const mobileMenu = document.getElementById('mobile-menu');
  const menuIcon = document.getElementById('menu-icon');
  const closeIcon = document.getElementById('close-icon');
  
  // Toggle mobile menu
  mobileMenuButton.addEventListener('click', function() {
    mobileMenu.classList.toggle('hidden');
    menuIcon.classList.toggle('hidden');
    closeIcon.classList.toggle('hidden');
  });

  // Mobile dropdown functionality
  const mobileDropdownToggles = document.querySelectorAll('.mobile-dropdown-toggle');
  
  mobileDropdownToggles.forEach(toggle => {
    toggle.addEventListener('click', function() {
      const content = this.nextElementSibling;
      const icon = this.querySelector('svg');
      
      content.classList.toggle('hidden');
      icon.classList.toggle('rotate-180');
    });
  });

  // Close mobile menu when clicking outside
  document.addEventListener('click', function(event) {
    if (!mobileMenuButton.contains(event.target) && !mobileMenu.contains(event.target)) {
      mobileMenu.classList.add('hidden');
      menuIcon.classList.remove('hidden');
      closeIcon.classList.add('hidden');
    }
  });
});
</script>
