<?php
// Navigation menu similar to Webflow's structure
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$current_dir = basename(dirname($_SERVER['PHP_SELF']));
?>

<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm border-bottom sticky-top" style="z-index: 1030;">
  <div class="container">
    <!-- Logo -->
    <a class="navbar-brand fw-bold text-primary" href="/">
      Neil Widdowson
      <small class="text-muted d-none d-sm-inline">IT & Web</small>
    </a>

    <!-- Mobile menu button -->
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Desktop Navigation -->
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        
        <!-- Services Dropdown -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="servicesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Services
          </a>
          <ul class="dropdown-menu dropdown-menu-lg-end" style="min-width: 350px;">
            <li><h6 class="dropdown-header">Website Services</h6></li>
            <li>
              <a class="dropdown-item" href="/services/website-design.php">
                <div class="fw-medium">Website Design</div>
                <small class="text-muted">Custom websites that win work</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/software-dev.php">
                <div class="fw-medium">Software Development</div>
                <small class="text-muted">Custom applications & solutions</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/seo.php">
                <div class="fw-medium">SEO & Marketing</div>
                <small class="text-muted">Get found online</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/services/website-care.php">
                <div class="fw-medium">Website Care</div>
                <small class="text-muted">Ongoing maintenance & support</small>
              </a>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li><h6 class="dropdown-header">IT Support</h6></li>
            <li>
              <a class="dropdown-item" href="/services/it-support.php">
                <div class="fw-medium">IT Support</div>
                <small class="text-muted">Friendly local technical support</small>
              </a>
            </li>
          </ul>
        </li>

        <!-- Portfolio -->
        <li class="nav-item">
          <a class="nav-link" href="/portfolio/">Portfolio</a>
        </li>

        <!-- About -->
        <li class="nav-item">
          <a class="nav-link" href="/about/">About</a>
        </li>

        <!-- Resources Dropdown -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="resourcesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Resources
          </a>
          <ul class="dropdown-menu">
            <li>
              <a class="dropdown-item" href="/pricing/">
                <div class="fw-medium">Pricing</div>
                <small class="text-muted">Transparent pricing for all services</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/faqs/">
                <div class="fw-medium">FAQs</div>
                <small class="text-muted">Common questions answered</small>
              </a>
            </li>
            <li>
              <a class="dropdown-item" href="/bitdefender/">
                <div class="fw-medium">Bitdefender</div>
                <small class="text-muted">Security solutions</small>
              </a>
            </li>
          </ul>
        </li>

        <!-- Contact -->
        <li class="nav-item">
          <a class="nav-link" href="/contact/">Contact</a>
        </li>
      </ul>

      <!-- CTA Button -->
      <div class="d-none d-lg-block">
        <a href="/contact/" class="btn btn-primary">
          Get Started
        </a>
      </div>
    </div>
  </div>
</nav>