  <header class="sticky top-0 z-40 border-b border-gray-100 bg-white/90 supports-[backdrop-filter]:bg-white/60 backdrop-blur">
    <div class="container py-3 md:p-6 relative">
      <div class="flex items-center justify-between">
        <a href="/" class="inline-flex items-center gap-3 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
          <div class="h-9 w-9 rounded-2xl bg-accent-600 text-white grid place-items-center font-bold">NW</div>
          <span class="text-gray-900 font-semibold leading-tight hidden md:block">Neil Widdowson<span class="block text-xs text-gray-500">IT & Website Services</span></span>
          <span class="visually-hidden">Home</span>
        </a>

        <nav class="hidden md:flex items-center gap-6" aria-label="Primary">
          <a href="/" class="text-gray-700 hover:text-gray-900">Home</a>

          <div class="relative" aria-haspopup="true">
            <a href="#" id="services-dropdown" aria-expanded="false" aria-controls="services-menu" class="text-gray-700 hover:text-gray-900 inline-flex items-center">
              Services
              <span id="services-arrow" class="ml-2 inline-block transition-transform">▾</span>
            </a>
          </div>

          <a href="/portfolio/" class="text-gray-700 hover:text-gray-900">Portfolio</a>
          <a href="/pricing/" class="text-gray-700 hover:text-gray-900">Pricing</a>
          <a href="/about/" class="text-gray-700 hover:text-gray-900">About</a>
          <a href="/contact/" class="btn-primary text-sm">Get a quote</a>
        </nav>

        <button id="nav-toggle" class="md:hidden h-10 w-10 grid place-items-center rounded hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500" aria-expanded="false" aria-controls="mobile-nav" aria-label="Toggle navigation">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
        </button>
      </div>

      <div id="services-menu" class="hidden opacity-0 invisible absolute left-0 right-0 top-full z-40">
        <div class="container">
          <div class="mt-3 rounded-2xl bg-white shadow-md border border-gray-100 p-6 grid gap-6 md:grid-cols-4">
            <div class="md:col-span-2 menu-links grid">
              <a href="/services/website-design.php" class="hover:bg-gray-50 rounded p-4 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="font-semibold text-gray-900">Website Design</div>
                <div class="text-sm text-gray-600">Fast, mobile-first sites. Joomla specialist.</div>
              </a>
              <a href="/services/it-support.php" class="hover:bg-gray-50 rounded p-4 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="font-semibold text-gray-900">IT Support</div>
                <div class="text-sm text-gray-600">Friendly on-site/remote help, email, backup, Wi‑Fi.</div>
              </a>
              <a href="/services/website-care.php" class="hover:bg-gray-50 rounded p-4 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="font-semibold text-gray-900">Website Care & Hosting</div>
                <div class="text-sm text-gray-600">Updates, backups, security and reliable hosting.</div>
              </a>
              <a href="/services/software-dev.php" class="hover:bg-gray-50 rounded p-4 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="font-semibold text-gray-900">Software Dev & AI</div>
                <div class="text-sm text-gray-600">Custom PHP tools, AI-assisted workflows, APIs.</div>
              </a>
              <a href="/services/seo.php" class="hover:bg-gray-50 rounded p-4 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="font-semibold text-gray-900">SEO</div>
                <div class="text-sm text-gray-600">Be found locally with ethical, content-first SEO.</div>
              </a>
            </div>
            <div class="md:col-span-2 grid md:grid-cols-2 gap-4">
              <a href="/portfolio/" class="card overflow-hidden p-0 block focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <img src="/img/screenshots/helliwellmedia.png" alt="Website screenshot example" loading="lazy" class="object-cover w-full h-40">
                <div class="p-4">
                  <div class="text-sm font-semibold text-gray-900">See recent work</div>
                  <div class="text-xs text-gray-600 mt-1">Real results for local businesses.</div>
                </div>
              </a>
              <a href="/contact/" class="card p-4 flex flex-col justify-center focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-accent-500">
                <div class="text-lg font-semibold text-gray-900">Get a free quote</div>
                <div class="text-sm text-gray-600 mt-2">Tell me what you need. Quick, no-pressure advice.</div>
                <div class="mt-4"><span class="btn-primary">Contact</span></div>
              </a>
            </div>
          </div>
        </div>
      </div>

      <div id="mobile-nav" class="hidden md:hidden border-t border-gray-100 mt-3">
        <nav class="py-3" aria-label="Mobile">
          <ul class="space-y-3 text-gray-700">
            <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/">Home</a></li>
            <li class="border-t border-gray-100 pt-3"><span class="px-2 text-sm font-semibold text-gray-900">Services</span>
              <ul class="mt-2 space-y-2">
                <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/services/website-design.php">Website Design</a></li>
                <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/services/it-support.php">IT Support</a></li>
                <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/services/website-care.php">Website Care & Hosting</a></li>
                <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/services/software-dev.php">Software Dev & AI</a></li>
                <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/services/seo.php">SEO</a></li>
              </ul>
            </li>
            <li class="border-t border-gray-100 pt-3"><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/portfolio/">Portfolio</a></li>
            <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/pricing/">Pricing</a></li>
            <li><a class="block px-2 py-2 hover:bg-gray-50 rounded" href="/about/">About</a></li>
            <li class="border-t border-gray-100 pt-3"><a class="btn-primary w-full" href="/contact/">Get a quote</a></li>
          </ul>
        </nav>
      </div>
    </div>
  </header>
  <div id="nav-overlay" class="hidden fixed inset-0 z-0 bg-gray-900" style="opacity:.35"></div>
