<?php
// Get current page for active states
$current_page = $_SERVER['REQUEST_URI'];
$current_page = rtrim($current_page, '/');
if (empty($current_page)) $current_page = '/';

function isActive($path, $current) {
    return $current === $path ? 'text-accent-600' : 'text-gray-700 hover:text-gray-900';
}

function isActiveParent($paths, $current) {
    foreach ($paths as $path) {
        if (strpos($current, $path) === 0) {
            return 'text-accent-600';
        }
    }
    return 'text-gray-700 hover:text-gray-900';
}
?>

<header class="sticky top-0 z-40 bg-white/90 backdrop-blur supports-[backdrop-filter]:bg-white/60 border-b border-gray-100">
  <nav class="container mx-auto px-4 lg:px-8" role="navigation" aria-label="Main navigation">
    <div class="flex items-center justify-between h-16">
      
      <!-- Logo -->
      <div class="flex-shrink-0">
        <a href="/" class="flex items-center space-x-2 text-xl font-bold text-gray-900 hover:text-accent-600 transition-colors">
          <svg class="w-8 h-8 text-accent-600 logo-icon" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
          </svg>
          <span>Neil Widdowson</span>
        </a>
      </div>

      <!-- Desktop Navigation -->
      <div class="hidden md:flex items-center space-x-1">
        
        <!-- Services Dropdown -->
        <div class="relative group">
          <button class="flex items-center px-3 py-2 text-sm font-medium <?php echo isActiveParent(['/services'], $current_page); ?> hover:bg-gray-50 rounded-lg transition-all duration-200 group-hover:bg-gray-50" 
                  aria-expanded="false" aria-haspopup="true">
            <span>Services</span>
            <svg class="ml-1 w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
          </button>
          
          <!-- Services Dropdown Menu -->
          <div class="absolute left-0 mt-1 w-80 bg-white rounded-xl shadow-lg border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform translate-y-1 group-hover:translate-y-0">
            <div class="p-4">
              <div class="mb-3">
                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Digital Solutions</p>
              </div>
              <div class="grid grid-cols-1 gap-1">
                <a href="/services/website-design" class="flex items-start p-3 rounded-lg hover:bg-gray-50 transition-colors group/item">
                  <div class="flex-shrink-0 w-8 h-8 bg-accent-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                  </div>
                  <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-gray-900 group-hover/item:text-accent-600">Website Design</p>
                    <p class="text-xs text-gray-500 mt-1">Beautiful, modern websites that convert visitors into customers</p>
                  </div>
                </a>
                
                <a href="/services/seo" class="flex items-start p-3 rounded-lg hover:bg-gray-50 transition-colors group/item">
                  <div class="flex-shrink-0 w-8 h-8 bg-accent-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                  </div>
                  <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-gray-900 group-hover/item:text-accent-600">SEO Services</p>
                    <p class="text-xs text-gray-500 mt-1">Get found online with expert search engine optimization</p>
                  </div>
                </a>
                
                <a href="/services/software-dev" class="flex items-start p-3 rounded-lg hover:bg-gray-50 transition-colors group/item">
                  <div class="flex-shrink-0 w-8 h-8 bg-accent-100 rounded-lg flex items-center justify-center mr-3">
                    <svg class="w-4 h-4 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"/>
                    </svg>
                  </div>
                  <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-gray-900 group-hover/item:text-accent-600">Software Development</p>
                    <p class="text-xs text-gray-500 mt-1">Custom applications and integrations for your business</p>
                  </div>
                </a>
              </div>
              
              <div class="mt-4 pt-3 border-t border-gray-100">
                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Support Services</p>
                <div class="grid grid-cols-1 gap-1">
                  <a href="/services/it-support" class="flex items-start p-3 rounded-lg hover:bg-gray-50 transition-colors group/item">
                    <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                      <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                      </svg>
                    </div>
                    <div class="flex-1 min-w-0">
                      <p class="text-sm font-medium text-gray-900 group-hover/item:text-green-600">IT Support</p>
                      <p class="text-xs text-gray-500 mt-1">Reliable technical support for your business systems</p>
                    </div>
                  </a>
                  
                  <a href="/services/website-care" class="flex items-start p-3 rounded-lg hover:bg-gray-50 transition-colors group/item">
                    <div class="flex-shrink-0 w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                      <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                      </svg>
                    </div>
                    <div class="flex-1 min-w-0">
                      <p class="text-sm font-medium text-gray-900 group-hover/item:text-green-600">Website Care</p>
                      <p class="text-xs text-gray-500 mt-1">Ongoing maintenance and security for your website</p>
                    </div>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Portfolio -->
        <a href="/portfolio" class="px-3 py-2 text-sm font-medium <?php echo isActive('/portfolio', $current_page); ?> hover:bg-gray-50 rounded-lg transition-all duration-200">
          Portfolio
        </a>

        <!-- Pricing -->
        <a href="/pricing" class="px-3 py-2 text-sm font-medium <?php echo isActive('/pricing', $current_page); ?> hover:bg-gray-50 rounded-lg transition-all duration-200">
          Pricing
        </a>

        <!-- About -->
        <a href="/about" class="px-3 py-2 text-sm font-medium <?php echo isActive('/about', $current_page); ?> hover:bg-gray-50 rounded-lg transition-all duration-200">
          About
        </a>

        <!-- Contact -->
        <a href="/contact" class="px-3 py-2 text-sm font-medium <?php echo isActive('/contact', $current_page); ?> hover:bg-gray-50 rounded-lg transition-all duration-200">
          Contact
        </a>

        <!-- CTA Button -->
        <div class="ml-4 pl-4 border-l border-gray-200">
          <a href="/contact" class="btn-primary">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
            </svg>
            Get Quote
          </a>
        </div>
      </div>

      <!-- Mobile menu button -->
      <div class="md:hidden">
        <button type="button" class="p-2 rounded-lg text-gray-700 hover:text-gray-900 hover:bg-gray-100 transition-colors" 
                aria-controls="mobile-menu" aria-expanded="false" onclick="toggleMobileMenu()">
          <span class="sr-only">Open main menu</span>
          <svg class="w-6 h-6" id="menu-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
          </svg>
          <svg class="w-6 h-6 hidden" id="close-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
          </svg>
        </button>
      </div>
    </div>

    <!-- Mobile Navigation Menu -->
    <div class="md:hidden hidden" id="mobile-menu">
      <div class="px-2 pt-2 pb-3 space-y-1 border-t border-gray-100 bg-white">
        
        <!-- Mobile Services Section -->
        <div class="space-y-1">
          <button class="w-full text-left px-3 py-2 text-base font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 rounded-lg flex items-center justify-between" 
                  onclick="toggleMobileDropdown('services')">
            <span>Services</span>
            <svg class="w-5 h-5 transition-transform" id="services-arrow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
          </button>
          
          <div class="hidden pl-4 space-y-1" id="services-dropdown">
            <a href="/services/website-design" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-lg">Website Design</a>
            <a href="/services/seo" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-lg">SEO Services</a>
            <a href="/services/software-dev" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-lg">Software Development</a>
            <a href="/services/it-support" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-lg">IT Support</a>
            <a href="/services/website-care" class="block px-3 py-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-lg">Website Care</a>
          </div>
        </div>

        <a href="/portfolio" class="block px-3 py-2 text-base font-medium <?php echo isActive('/portfolio', $current_page); ?> hover:bg-gray-50 rounded-lg">Portfolio</a>
        <a href="/pricing" class="block px-3 py-2 text-base font-medium <?php echo isActive('/pricing', $current_page); ?> hover:bg-gray-50 rounded-lg">Pricing</a>
        <a href="/about" class="block px-3 py-2 text-base font-medium <?php echo isActive('/about', $current_page); ?> hover:bg-gray-50 rounded-lg">About</a>
        <a href="/contact" class="block px-3 py-2 text-base font-medium <?php echo isActive('/contact', $current_page); ?> hover:bg-gray-50 rounded-lg">Contact</a>
        
        <!-- Mobile CTA -->
        <div class="pt-4 mt-4 border-t border-gray-200">
          <a href="/contact" class="block w-full btn-primary text-center">
            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
            </svg>
            Get Quote
          </a>
        </div>
      </div>
    </div>
  </nav>
</header>

<script>
// Mobile menu toggle
function toggleMobileMenu() {
  const mobileMenu = document.getElementById('mobile-menu');
  const menuIcon = document.getElementById('menu-icon');
  const closeIcon = document.getElementById('close-icon');
  
  if (mobileMenu.classList.contains('hidden')) {
    mobileMenu.classList.remove('hidden');
    menuIcon.classList.add('hidden');
    closeIcon.classList.remove('hidden');
    document.querySelector('[aria-controls="mobile-menu"]').setAttribute('aria-expanded', 'true');
  } else {
    mobileMenu.classList.add('hidden');
    menuIcon.classList.remove('hidden');
    closeIcon.classList.add('hidden');
    document.querySelector('[aria-controls="mobile-menu"]').setAttribute('aria-expanded', 'false');
  }
}

// Mobile dropdown toggle
function toggleMobileDropdown(section) {
  const dropdown = document.getElementById(section + '-dropdown');
  const arrow = document.getElementById(section + '-arrow');
  
  if (dropdown.classList.contains('hidden')) {
    dropdown.classList.remove('hidden');
    arrow.style.transform = 'rotate(180deg)';
  } else {
    dropdown.classList.add('hidden');
    arrow.style.transform = 'rotate(0deg)';
  }
}

// Close mobile menu when clicking outside
document.addEventListener('click', function(event) {
  const mobileMenu = document.getElementById('mobile-menu');
  const menuButton = document.querySelector('[aria-controls="mobile-menu"]');
  
  if (!mobileMenu.contains(event.target) && !menuButton.contains(event.target)) {
    if (!mobileMenu.classList.contains('hidden')) {
      toggleMobileMenu();
    }
  }
});

// Close mobile menu on resize to desktop
window.addEventListener('resize', function() {
  if (window.innerWidth >= 768) {
    const mobileMenu = document.getElementById('mobile-menu');
    if (!mobileMenu.classList.contains('hidden')) {
      toggleMobileMenu();
    }
  }
});
</script>
